/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.script.mvel;

import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.script.mvel.ExpressionScriptCompiledMVEL;
import com.espertech.esper.epl.script.mvel.MVELInvoker;
import com.espertech.esper.epl.spec.ExpressionScriptCompiled;
import com.espertech.esper.epl.spec.ExpressionScriptProvided;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MVELHelper {
    private static final Log log = LogFactory.getLog(MVELHelper.class);

    public static void verifyScript(ExpressionScriptProvided script) throws ExprValidationException {
        Object parserContext = MVELInvoker.newParserContext();
        try {
            MVELInvoker.analysisCompile(script.getExpression(), parserContext);
        }
        catch (InvocationTargetException ex) {
            throw MVELHelper.handleTargetException(script.getName(), ex);
        }
        catch (Exception ex) {
            throw MVELHelper.handleGeneralException(script.getName(), ex);
        }
        Map<String, Class> scriptRequiredInputs = MVELInvoker.getParserContextInputs(parserContext);
        for (Map.Entry<String, Class> input : scriptRequiredInputs.entrySet()) {
            if (input.getKey().toLowerCase().trim().equals("epl") || script.getParameterNames().contains(input.getKey())) continue;
            throw new ExprValidationException("For script '" + script.getName() + "' the variable '" + input.getKey() + "' has not been declared and is not a parameter");
        }
    }

    public static ExpressionScriptCompiled compile(String scriptName, String expression, Map<String, Class> mvelInputParamTypes) throws ExprValidationException {
        Object executable;
        Object parserContext = MVELInvoker.newParserContext();
        MVELInvoker.setParserContextStrongTyping(parserContext);
        MVELInvoker.setParserContextInputs(parserContext, mvelInputParamTypes);
        try {
            executable = MVELInvoker.compileExpression(expression, parserContext);
        }
        catch (InvocationTargetException ex) {
            throw MVELHelper.handleTargetException(scriptName, ex);
        }
        catch (Exception ex) {
            throw MVELHelper.handleGeneralException(scriptName, ex);
        }
        return new ExpressionScriptCompiledMVEL(executable);
    }

    private static ExprValidationException handleTargetException(String scriptName, InvocationTargetException ex) {
        Throwable mvelException = ex.getTargetException();
        String message = "Exception compiling MVEL script '" + scriptName + "': " + mvelException.getMessage();
        log.info((Object)message, mvelException);
        return new ExprValidationException(message, mvelException);
    }

    private static ExprValidationException handleGeneralException(String scriptName, Exception ex) {
        String message = "Exception compiling MVEL script '" + scriptName + "': " + ex.getMessage();
        log.info((Object)message, (Throwable)ex);
        return new ExprValidationException(message, ex);
    }
}

