/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.table.mgmt;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.service.AggregationRowPair;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnPairAggAccess;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnPairAggMethod;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnPairBase;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnPairPlainCol;
import com.espertech.esper.epl.table.strategy.ExprTableEvalStrategyUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.ObjectArrayBackedEventBean;
import com.espertech.esper.event.arr.ObjectArrayEventType;

public class TableMetadataInternalEventToPublic {
    private final ObjectArrayEventType publicEventType;
    private final TableMetadataColumnPairPlainCol[] plains;
    private final TableMetadataColumnPairAggMethod[] methods;
    private final TableMetadataColumnPairAggAccess[] accessors;
    private final EventAdapterService eventAdapterService;
    private final int numColumns;

    public TableMetadataInternalEventToPublic(ObjectArrayEventType publicEventType, TableMetadataColumnPairPlainCol[] plains, TableMetadataColumnPairAggMethod[] methods, TableMetadataColumnPairAggAccess[] accessors, EventAdapterService eventAdapterService) {
        this.publicEventType = publicEventType;
        this.plains = plains;
        this.methods = methods;
        this.accessors = accessors;
        this.eventAdapterService = eventAdapterService;
        this.numColumns = publicEventType.getPropertyDescriptors().length;
    }

    public EventBean convert(EventBean event, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object[] data = this.convertToUnd(event, eventsPerStream, isNewData, context);
        return this.eventAdapterService.adapterForType(data, this.publicEventType);
    }

    public Object[] convertToUnd(EventBean event, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ObjectArrayBackedEventBean bean = (ObjectArrayBackedEventBean)event;
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow(bean);
        Object[] data = new Object[this.numColumns];
        for (TableMetadataColumnPairPlainCol plain : this.plains) {
            data[plain.getDest()] = bean.getProperties()[plain.getSource()];
        }
        int count = 0;
        for (TableMetadataColumnPairAggAccess tableMetadataColumnPairAggAccess : this.accessors) {
            data[tableMetadataColumnPairAggAccess.getDest()] = tableMetadataColumnPairAggAccess.getAccessor().getValue(row.getStates()[count++], eventsPerStream, isNewData, context);
        }
        count = 0;
        for (TableMetadataColumnPairBase tableMetadataColumnPairBase : this.methods) {
            data[tableMetadataColumnPairBase.getDest()] = row.getMethods()[count++].getValue();
        }
        return data;
    }
}

