/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.table.onaction;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.lookup.SubordWMatchExprLookupStrategy;
import com.espertech.esper.epl.named.NamedWindowOnSelectView;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.epl.table.onaction.TableOnSelectViewFactory;
import com.espertech.esper.epl.table.onaction.TableOnViewBase;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.AuditPath;
import java.util.Collections;
import java.util.Set;

public class TableOnSelectView
extends TableOnViewBase {
    private final TableOnSelectViewFactory parent;
    private final ResultSetProcessor resultSetProcessor;
    private final boolean audit;
    private final boolean deleteAndSelect;

    public TableOnSelectView(SubordWMatchExprLookupStrategy lookupStrategy, TableStateInstance rootView, ExprEvaluatorContext exprEvaluatorContext, TableMetadata metadata, TableOnSelectViewFactory parent, ResultSetProcessor resultSetProcessor, boolean audit, boolean deleteAndSelect) {
        super(lookupStrategy, rootView, exprEvaluatorContext, metadata, deleteAndSelect);
        this.parent = parent;
        this.resultSetProcessor = resultSetProcessor;
        this.audit = audit;
        this.deleteAndSelect = deleteAndSelect;
    }

    @Override
    public void handleMatching(EventBean[] triggerEvents, EventBean[] matchingEvents) {
        EventBean[] newData;
        this.resultSetProcessor.clear();
        Set<MultiKey<EventBean>> newEvents = NamedWindowOnSelectView.buildJoinResult(triggerEvents, matchingEvents);
        UniformPair<EventBean[]> pair = this.resultSetProcessor.processJoinResult(newEvents, Collections.<MultiKey<EventBean>>emptySet(), false);
        EventBean[] eventBeanArray = newData = pair != null ? pair.getFirst() : null;
        if (this.parent.isDistinct()) {
            newData = EventBeanUtility.getDistinctByProp(newData, this.parent.getEventBeanReader());
        }
        if (this.parent.getInternalEventRouter() != null && newData != null) {
            for (int i = 0; i < newData.length; ++i) {
                if (this.audit) {
                    AuditPath.auditInsertInto(this.getExprEvaluatorContext().getEngineURI(), this.getExprEvaluatorContext().getStatementName(), newData[i]);
                }
                this.parent.getInternalEventRouter().route(newData[i], this.parent.getStatementHandle(), this.parent.getInternalEventRouteDest(), this.getExprEvaluatorContext(), false);
            }
        }
        if (newData != null && newData.length > 0 && (this.parent.getStatementResultService().isMakeNatural() || this.parent.getStatementResultService().isMakeSynthetic())) {
            this.updateChildren(newData, null);
        }
        this.resultSetProcessor.clear();
        if (this.deleteAndSelect) {
            for (EventBean event : matchingEvents) {
                this.tableStateInstance.deleteEvent(event);
            }
        }
    }

    @Override
    public EventType getEventType() {
        if (this.resultSetProcessor != null) {
            return this.resultSetProcessor.getResultEventType();
        }
        return super.getEventType();
    }
}

