/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.table.upd;

import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.lookup.EventTableIndexMetadataEntry;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.lookup.IndexedPropDesc;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.upd.TableUpdateStrategy;
import com.espertech.esper.epl.table.upd.TableUpdateStrategyIndexNonUnique;
import com.espertech.esper.epl.table.upd.TableUpdateStrategyNonIndex;
import com.espertech.esper.epl.table.upd.TableUpdateStrategyWUniqueConstraint;
import com.espertech.esper.epl.updatehelper.EventBeanUpdateHelper;
import com.espertech.esper.epl.updatehelper.EventBeanUpdateItem;
import java.util.LinkedHashSet;
import java.util.Map;

public class TableUpdateStrategyFactory {
    public static TableUpdateStrategy validateGetTableUpdateStrategy(TableMetadata tableMetadata, EventBeanUpdateHelper updateHelper, boolean isOnMerge) throws ExprValidationException {
        LinkedHashSet<String> affectedIndexNames = null;
        boolean uniqueIndexUpdated = false;
        for (Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> index : tableMetadata.getEventTableIndexMetadataRepo().getIndexes().entrySet()) {
            for (EventBeanUpdateItem updateItem : updateHelper.getUpdateItems()) {
                boolean match;
                if (updateItem.getOptionalPropertyName() == null || !(match = TableUpdateStrategyFactory.determineUpdatesIndex(updateItem, index.getKey()))) continue;
                if (affectedIndexNames == null) {
                    affectedIndexNames = new LinkedHashSet<String>();
                }
                affectedIndexNames.add(index.getValue().getOptionalIndexName());
                uniqueIndexUpdated |= index.getKey().isUnique();
            }
        }
        if (affectedIndexNames != null && uniqueIndexUpdated) {
            if (isOnMerge) {
                throw new ExprValidationException("On-merge statements may not update unique keys of tables");
            }
            return new TableUpdateStrategyWUniqueConstraint(updateHelper, affectedIndexNames);
        }
        if (affectedIndexNames != null) {
            return new TableUpdateStrategyIndexNonUnique(updateHelper, affectedIndexNames);
        }
        return new TableUpdateStrategyNonIndex(updateHelper);
    }

    private static boolean determineUpdatesIndex(EventBeanUpdateItem updateItem, IndexMultiKey key) {
        for (IndexedPropDesc prop : key.getHashIndexedProps()) {
            if (!prop.getIndexPropName().equals(updateItem.getOptionalPropertyName())) continue;
            return true;
        }
        for (IndexedPropDesc prop : key.getRangeIndexedProps()) {
            if (!prop.getIndexPropName().equals(updateItem.getOptionalPropertyName())) continue;
            return true;
        }
        return false;
    }
}

