/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.table.upd;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.epl.table.upd.TableUpdateStrategy;
import com.espertech.esper.epl.updatehelper.EventBeanUpdateHelper;
import com.espertech.esper.event.ObjectArrayBackedEventBean;
import com.espertech.esper.event.arr.ObjectArrayEventBean;
import java.util.Collection;
import java.util.Set;

public class TableUpdateStrategyWUniqueConstraint
implements TableUpdateStrategy {
    private final EventBeanUpdateHelper updateHelper;
    private final Set<String> affectedIndexNames;

    public TableUpdateStrategyWUniqueConstraint(EventBeanUpdateHelper updateHelper, Set<String> affectedIndexNames) {
        this.updateHelper = updateHelper;
        this.affectedIndexNames = affectedIndexNames;
    }

    @Override
    public void updateTable(Collection<EventBean> eventsUnsafeIter, TableStateInstance instance, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean[] events = new EventBean[eventsUnsafeIter.size()];
        int count = 0;
        for (EventBean event : eventsUnsafeIter) {
            events[count++] = event;
        }
        for (String affectedIndexName : this.affectedIndexNames) {
            EventTable index = instance.getIndex(affectedIndexName);
            index.remove(events);
        }
        Object[][] previousData = new Object[events.length][];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            ObjectArrayBackedEventBean updatedEvent = (ObjectArrayBackedEventBean)events[i];
            Object[] prev = new Object[updatedEvent.getProperties().length];
            System.arraycopy(updatedEvent.getProperties(), 0, prev, 0, prev.length);
            previousData[i] = prev;
            if (this.updateHelper.isRequiresStream2InitialValueEvent()) {
                eventsPerStream[2] = new ObjectArrayEventBean(prev, updatedEvent.getEventType());
            }
            instance.handleRowUpdateKeyBeforeUpdate(updatedEvent);
            this.updateHelper.updateNoCopy(updatedEvent, eventsPerStream, exprEvaluatorContext);
            instance.handleRowUpdateKeyAfterUpdate(updatedEvent);
        }
        try {
            for (String affectedIndexName : this.affectedIndexNames) {
                EventTable index = instance.getIndex(affectedIndexName);
                index.add(events);
            }
        }
        catch (EPException ex) {
            EventTable index;
            for (String affectedIndexName : this.affectedIndexNames) {
                index = instance.getIndex(affectedIndexName);
                index.remove(events);
            }
            for (int i = 0; i < events.length; ++i) {
                ObjectArrayBackedEventBean oa = (ObjectArrayBackedEventBean)events[i];
                oa.setPropertyValues(previousData[i]);
            }
            for (String affectedIndexName : this.affectedIndexNames) {
                index = instance.getIndex(affectedIndexName);
                index.add(events);
            }
            throw ex;
        }
    }
}

