/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.variable;

import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.variable.VariableVersionThreadEntry;
import com.espertech.esper.epl.variable.VariableVersionThreadLocal;
import com.espertech.esper.epl.variable.VersionedValueList;

public class VariableReader {
    private final VariableMetaData variableMetaData;
    private final VariableVersionThreadLocal versionThreadLocal;
    private volatile VersionedValueList<Object> versionsHigh;
    private volatile VersionedValueList<Object> versionsLow;

    public VariableReader(VariableMetaData variableMetaData, VariableVersionThreadLocal versionThreadLocal, VersionedValueList<Object> versionsLow) {
        this.variableMetaData = variableMetaData;
        this.versionThreadLocal = versionThreadLocal;
        this.versionsLow = versionsLow;
        this.versionsHigh = null;
    }

    public void setVersionsHigh(VersionedValueList<Object> versionsHigh) {
        this.versionsHigh = versionsHigh;
    }

    public void setVersionsLow(VersionedValueList<Object> versionsLow) {
        this.versionsLow = versionsLow;
    }

    public Object getValue() {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        if (entry.getUncommitted() != null && entry.getUncommitted().containsKey(this.variableMetaData.getVariableNumber())) {
            return entry.getUncommitted().get(this.variableMetaData.getVariableNumber()).getSecond();
        }
        int myVersion = entry.getVersion();
        VersionedValueList<Object> versions = this.versionsLow;
        if (myVersion >= 2147383647 && this.versionsHigh != null) {
            versions = this.versionsHigh;
        }
        return versions.getVersion(myVersion);
    }

    public VariableMetaData getVariableMetaData() {
        return this.variableMetaData;
    }

    public VersionedValueList<Object> getVersionsLow() {
        return this.versionsLow;
    }
}

