/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.variable;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.VariableValueException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.service.StatementExtensionSvcContext;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.variable.VariableChangeCallback;
import com.espertech.esper.epl.variable.VariableExistsException;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.epl.variable.VariableServiceUtil;
import com.espertech.esper.epl.variable.VariableStateFactoryConst;
import com.espertech.esper.epl.variable.VariableStateHandler;
import com.espertech.esper.epl.variable.VariableTypeException;
import com.espertech.esper.epl.variable.VariableVersionThreadEntry;
import com.espertech.esper.epl.variable.VariableVersionThreadLocal;
import com.espertech.esper.epl.variable.VersionedValueList;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VariableServiceImpl
implements VariableService {
    private static Log log = LogFactory.getLog(VariableServiceImpl.class);
    protected static final int ROLLOVER_READER_BOUNDARY = 2147383647;
    protected static final int HIGH_WATERMARK_VERSIONS = 50;
    private final ArrayList<ConcurrentHashMap<Integer, VariableReader>> variableVersionsPerCP;
    private final ArrayList<Map<Integer, Set<VariableChangeCallback>>> changeCallbacksPerCP;
    private final Map<String, VariableMetaData> variables;
    private final ReadWriteLock readWriteLock;
    private VariableVersionThreadLocal versionThreadLocal = new VariableVersionThreadLocal();
    private final long millisecondLifetimeOldVersions;
    private final TimeProvider timeProvider;
    private final EventAdapterService eventAdapterService;
    private final VariableStateHandler optionalStateHandler;
    private volatile int currentVersionNumber;
    private int currentVariableNumber;

    public VariableServiceImpl(long millisecondLifetimeOldVersions, TimeProvider timeProvider, EventAdapterService eventAdapterService, VariableStateHandler optionalStateHandler) {
        this(0, millisecondLifetimeOldVersions, timeProvider, eventAdapterService, optionalStateHandler);
    }

    protected VariableServiceImpl(int startVersion, long millisecondLifetimeOldVersions, TimeProvider timeProvider, EventAdapterService eventAdapterService, VariableStateHandler optionalStateHandler) {
        this.millisecondLifetimeOldVersions = millisecondLifetimeOldVersions;
        this.timeProvider = timeProvider;
        this.eventAdapterService = eventAdapterService;
        this.optionalStateHandler = optionalStateHandler;
        this.variables = new HashMap<String, VariableMetaData>();
        this.readWriteLock = new ReentrantReadWriteLock();
        this.variableVersionsPerCP = new ArrayList();
        this.changeCallbacksPerCP = new ArrayList();
        this.currentVersionNumber = startVersion;
    }

    @Override
    public void destroy() {
        this.versionThreadLocal = new VariableVersionThreadLocal();
    }

    @Override
    public synchronized void removeVariableIfFound(String name) {
        VariableMetaData metaData = this.variables.get(name);
        if (metaData == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing variable '" + name + "'"));
        }
        this.variables.remove(name);
        if (this.optionalStateHandler != null) {
            ConcurrentHashMap<Integer, VariableReader> readers = this.variableVersionsPerCP.get(metaData.getVariableNumber());
            Set cps = Collections.emptySet();
            if (readers != null) {
                cps = readers.keySet();
            }
            this.optionalStateHandler.removeVariable(name, cps);
        }
        int number = metaData.getVariableNumber();
        this.variableVersionsPerCP.set(number, null);
        this.changeCallbacksPerCP.set(number, null);
    }

    @Override
    public void setLocalVersion() {
        this.versionThreadLocal.getCurrentThread().setVersion(this.currentVersionNumber);
    }

    @Override
    public void registerCallback(String variableName, int agentInstanceId, VariableChangeCallback variableChangeCallback) {
        Set<VariableChangeCallback> callbacks;
        VariableMetaData metaData = this.variables.get(variableName);
        if (metaData == null) {
            return;
        }
        Map<Integer, Set<VariableChangeCallback>> cps = this.changeCallbacksPerCP.get(metaData.getVariableNumber());
        if (cps == null) {
            cps = new HashMap<Integer, Set<VariableChangeCallback>>();
            this.changeCallbacksPerCP.set(metaData.getVariableNumber(), cps);
        }
        if (metaData.getContextPartitionName() == null) {
            agentInstanceId = -1;
        }
        if ((callbacks = cps.get(agentInstanceId)) == null) {
            callbacks = new CopyOnWriteArraySet<VariableChangeCallback>();
            cps.put(agentInstanceId, callbacks);
        }
        callbacks.add(variableChangeCallback);
    }

    @Override
    public void unregisterCallback(String variableName, int agentInstanceId, VariableChangeCallback variableChangeCallback) {
        Set<VariableChangeCallback> callbacks;
        VariableMetaData metaData = this.variables.get(variableName);
        if (metaData == null) {
            return;
        }
        Map<Integer, Set<VariableChangeCallback>> cps = this.changeCallbacksPerCP.get(metaData.getVariableNumber());
        if (cps == null) {
            return;
        }
        if (metaData.getContextPartitionName() == null) {
            agentInstanceId = 0;
        }
        if ((callbacks = cps.get(agentInstanceId)) != null) {
            callbacks.remove(variableChangeCallback);
        }
    }

    @Override
    public void createNewVariable(String optionalContextName, String variableName, String variableType, boolean constant, boolean array, boolean arrayOfPrimitive, Object value, EngineImportService engineImportService) throws VariableExistsException, VariableTypeException {
        Class primitiveType = JavaClassHelper.getPrimitiveClassForName(variableType);
        Class type = JavaClassHelper.getClassForSimpleName(variableType);
        Class arrayType = null;
        EventType eventType = null;
        if (type == null) {
            if (variableType.toLowerCase().equals("object")) {
                type = Object.class;
            }
            if (type == null && (eventType = this.eventAdapterService.getExistsTypeByName(variableType)) != null) {
                type = eventType.getUnderlyingType();
            }
            if (type == null) {
                try {
                    type = engineImportService.resolveClass(variableType, false);
                    if (array) {
                        arrayType = JavaClassHelper.getArrayType(type);
                    }
                }
                catch (EngineImportException e) {
                    log.debug((Object)("Not found '" + type + "': " + e.getMessage()), (Throwable)e);
                }
            }
            if (type == null) {
                throw new VariableTypeException("Cannot create variable '" + variableName + "', type '" + variableType + "' is not a recognized type");
            }
            if (array && eventType != null) {
                throw new VariableTypeException("Cannot create variable '" + variableName + "', type '" + variableType + "' cannot be declared as an array type");
            }
        } else if (array) {
            if (arrayOfPrimitive) {
                if (primitiveType == null) {
                    throw new VariableTypeException("Cannot create variable '" + variableName + "', type '" + variableType + "' is not a primitive type");
                }
                arrayType = JavaClassHelper.getArrayType(primitiveType);
            } else {
                arrayType = JavaClassHelper.getArrayType(type);
            }
        }
        if (!(eventType != null || JavaClassHelper.isJavaBuiltinDataType(type) || type == Object.class || type.isArray() || type.isEnum())) {
            if (array) {
                throw new VariableTypeException("Cannot create variable '" + variableName + "', type '" + variableType + "' cannot be declared as an array, only scalar types can be array");
            }
            eventType = this.eventAdapterService.addBeanType(type.getName(), type, false, false, false);
        }
        if (arrayType != null) {
            type = arrayType;
        }
        this.createNewVariable(variableName, optionalContextName, type, eventType, constant, value);
    }

    private synchronized void createNewVariable(String variableName, String optionalContextName, Class type, EventType eventType, boolean constant, Object value) throws VariableExistsException, VariableTypeException {
        int variableNumber;
        Class variableType = JavaClassHelper.getBoxedType(type);
        VariableMetaData metaData = this.variables.get(variableName);
        if (metaData != null) {
            throw new VariableExistsException(VariableServiceUtil.getAlreadyDeclaredEx(variableName, false));
        }
        int emptySpot = -1;
        int count = 0;
        for (ConcurrentHashMap<Integer, VariableReader> entry : this.variableVersionsPerCP) {
            if (entry == null) {
                emptySpot = count;
                break;
            }
            ++count;
        }
        if (emptySpot != -1) {
            variableNumber = emptySpot;
            this.variableVersionsPerCP.set(emptySpot, new ConcurrentHashMap());
            this.changeCallbacksPerCP.set(emptySpot, null);
        } else {
            variableNumber = this.currentVariableNumber++;
            this.variableVersionsPerCP.add(new ConcurrentHashMap());
            this.changeCallbacksPerCP.add(null);
        }
        Object coercedValue = value;
        if (eventType != null) {
            if (value != null && !JavaClassHelper.isSubclassOrImplementsInterface(value.getClass(), eventType.getUnderlyingType())) {
                throw new VariableTypeException("Variable '" + variableName + "' of declared event type '" + eventType.getName() + "' underlying type '" + eventType.getUnderlyingType().getName() + "' cannot be assigned a value of type '" + value.getClass().getName() + "'");
            }
            coercedValue = this.eventAdapterService.adapterForType(value, eventType);
        } else if (variableType != Object.class) {
            if (coercedValue != null && coercedValue instanceof String) {
                try {
                    coercedValue = JavaClassHelper.parse(variableType, (String)coercedValue);
                }
                catch (Exception ex) {
                    throw new VariableTypeException("Variable '" + variableName + "' of declared type " + JavaClassHelper.getClassNameFullyQualPretty(variableType) + " cannot be initialized by value '" + coercedValue + "': " + ex.toString());
                }
            }
            if (coercedValue != null && variableType != coercedValue.getClass()) {
                if (!JavaClassHelper.isNumeric(variableType) || !(coercedValue instanceof Number)) {
                    throw VariableServiceImpl.getVariableTypeException(variableName, variableType, coercedValue.getClass());
                }
                if (!JavaClassHelper.canCoerce(coercedValue.getClass(), variableType)) {
                    throw VariableServiceImpl.getVariableTypeException(variableName, variableType, coercedValue.getClass());
                }
                coercedValue = JavaClassHelper.coerceBoxed((Number)coercedValue, variableType);
            }
        }
        Object initialState = coercedValue;
        VariableStateFactoryConst stateFactory = new VariableStateFactoryConst(initialState);
        metaData = new VariableMetaData(variableName, optionalContextName, variableNumber, variableType, eventType, constant, stateFactory);
        this.variables.put(variableName, metaData);
    }

    @Override
    public void allocateVariableState(String variableName, int agentInstanceId, StatementExtensionSvcContext extensionServicesContext, boolean isRecoveringResilient) {
        VariableMetaData metaData = this.variables.get(variableName);
        if (metaData == null) {
            throw new IllegalArgumentException("Failed to find variable '" + variableName + "'");
        }
        Object initialState = metaData.getVariableStateFactory().getInitialState();
        if (this.optionalStateHandler != null) {
            Pair<Boolean, Object> priorValue = this.optionalStateHandler.getHasState(variableName, metaData.getVariableNumber(), agentInstanceId, metaData.getType(), metaData.getEventType(), extensionServicesContext, metaData.isConstant());
            if (isRecoveringResilient) {
                if (priorValue.getFirst().booleanValue()) {
                    initialState = priorValue.getSecond();
                }
            } else {
                this.optionalStateHandler.setState(variableName, metaData.getVariableNumber(), agentInstanceId, initialState);
            }
        }
        long timestamp = this.timeProvider.getTime();
        VersionedValueList<Object> valuePerVersion = new VersionedValueList<Object>(variableName, this.currentVersionNumber, initialState, timestamp, this.millisecondLifetimeOldVersions, this.readWriteLock.readLock(), 50, false);
        Map cps = this.variableVersionsPerCP.get(metaData.getVariableNumber());
        VariableReader reader = new VariableReader(metaData, this.versionThreadLocal, valuePerVersion);
        cps.put(agentInstanceId, reader);
    }

    @Override
    public void deallocateVariableState(String variableName, int agentInstanceId) {
        VariableMetaData metaData = this.variables.get(variableName);
        if (metaData == null) {
            throw new IllegalArgumentException("Failed to find variable '" + variableName + "'");
        }
        Map cps = this.variableVersionsPerCP.get(metaData.getVariableNumber());
        cps.remove(agentInstanceId);
        if (this.optionalStateHandler != null) {
            this.optionalStateHandler.removeState(variableName, metaData.getVariableNumber(), agentInstanceId);
        }
    }

    @Override
    public VariableMetaData getVariableMetaData(String variableName) {
        return this.variables.get(variableName);
    }

    @Override
    public VariableReader getReader(String variableName, int agentInstanceIdAccessor) {
        VariableMetaData metaData = this.variables.get(variableName);
        if (metaData == null) {
            return null;
        }
        Map cps = this.variableVersionsPerCP.get(metaData.getVariableNumber());
        if (metaData.getContextPartitionName() == null) {
            return (VariableReader)cps.get(-1);
        }
        return (VariableReader)cps.get(agentInstanceIdAccessor);
    }

    @Override
    public String isContextVariable(String variableName) {
        VariableMetaData metaData = this.variables.get(variableName);
        if (metaData == null) {
            return null;
        }
        return metaData.getContextPartitionName();
    }

    @Override
    public void write(int variableNumber, int agentInstanceId, Object newValue) {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        if (entry.getUncommitted() == null) {
            entry.setUncommitted(new HashMap<Integer, Pair<Integer, Object>>());
        }
        entry.getUncommitted().put(variableNumber, new Pair<Integer, Object>(agentInstanceId, newValue));
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    @Override
    public void commit() {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        if (entry.getUncommitted() == null) {
            return;
        }
        int newVersion = this.currentVersionNumber + 1;
        if (this.currentVersionNumber == 2147383647) {
            this.rollOver();
            newVersion = 2;
        }
        long timestamp = this.timeProvider.getTime();
        for (Map.Entry<Integer, Pair<Integer, Object>> uncommittedEntry : entry.getUncommitted().entrySet()) {
            Set<VariableChangeCallback> callbacks;
            Map cps = this.variableVersionsPerCP.get(uncommittedEntry.getKey());
            VariableReader reader = (VariableReader)cps.get(uncommittedEntry.getValue().getFirst());
            VersionedValueList<Object> versions = reader.getVersionsLow();
            Object newValue = uncommittedEntry.getValue().getSecond();
            Object oldValue = versions.addValue(newVersion, newValue, timestamp);
            Map<Integer, Set<VariableChangeCallback>> cpsCallback = this.changeCallbacksPerCP.get(uncommittedEntry.getKey());
            if (cpsCallback != null && (callbacks = cpsCallback.get(uncommittedEntry.getValue().getFirst())) != null) {
                for (VariableChangeCallback callback : callbacks) {
                    callback.update(newValue, oldValue);
                }
            }
            if (this.optionalStateHandler == null) continue;
            String name = versions.getName();
            int agentInstanceId = reader.getVariableMetaData().getContextPartitionName() == null ? -1 : uncommittedEntry.getValue().getFirst();
            this.optionalStateHandler.setState(name, uncommittedEntry.getKey(), agentInstanceId, newValue);
        }
        this.currentVersionNumber = newVersion;
        entry.setUncommitted(null);
    }

    @Override
    public void rollback() {
        VariableVersionThreadEntry entry = this.versionThreadLocal.getCurrentThread();
        entry.setUncommitted(null);
    }

    private void rollOver() {
        for (ConcurrentHashMap<Integer, VariableReader> entryCP : this.variableVersionsPerCP) {
            for (Map.Entry entry : entryCP.entrySet()) {
                String name = ((VariableReader)entry.getValue()).getVariableMetaData().getVariableName();
                long timestamp = this.timeProvider.getTime();
                VersionedValueList<Object> versionsOld = ((VariableReader)entry.getValue()).getVersionsLow();
                Object currentValue = versionsOld.getCurrentAndPriorValue().getCurrentVersion().getValue();
                VersionedValueList<Object> versionsNew = new VersionedValueList<Object>(name, 1, currentValue, timestamp, this.millisecondLifetimeOldVersions, this.readWriteLock.readLock(), 50, false);
                ((VariableReader)entry.getValue()).setVersionsHigh(versionsOld);
                ((VariableReader)entry.getValue()).setVersionsLow(versionsNew);
            }
        }
    }

    @Override
    public void checkAndWrite(String variableName, int agentInstanceId, Object newValue) throws VariableValueException {
        VariableMetaData metaData = this.variables.get(variableName);
        int variableNumber = metaData.getVariableNumber();
        if (newValue == null) {
            this.write(variableNumber, agentInstanceId, null);
            return;
        }
        Class<?> valueType = newValue.getClass();
        if (metaData.getEventType() != null) {
            if (!JavaClassHelper.isSubclassOrImplementsInterface(newValue.getClass(), metaData.getEventType().getUnderlyingType())) {
                throw new VariableValueException("Variable '" + variableName + "' of declared event type '" + metaData.getEventType().getName() + "' underlying type '" + metaData.getEventType().getUnderlyingType().getName() + "' cannot be assigned a value of type '" + valueType.getName() + "'");
            }
            EventBean eventBean = this.eventAdapterService.adapterForType(newValue, metaData.getEventType());
            this.write(variableNumber, agentInstanceId, eventBean);
            return;
        }
        Class variableType = metaData.getType();
        if (valueType.equals(variableType) || variableType == Object.class) {
            this.write(variableNumber, agentInstanceId, newValue);
            return;
        }
        if (!JavaClassHelper.isNumeric(variableType) || !JavaClassHelper.isNumeric(valueType)) {
            throw new VariableValueException(VariableServiceUtil.getAssigmentExMessage(variableName, variableType, valueType));
        }
        if (!JavaClassHelper.canCoerce(valueType, variableType)) {
            throw new VariableValueException(VariableServiceUtil.getAssigmentExMessage(variableName, variableType, valueType));
        }
        Number valueCoerced = JavaClassHelper.coerceBoxed((Number)newValue, variableType);
        this.write(variableNumber, agentInstanceId, valueCoerced);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        for (Map.Entry<String, VariableMetaData> entryMeta : this.variables.entrySet()) {
            int variableNum = entryMeta.getValue().getVariableNumber();
            for (Map.Entry<Integer, VariableReader> entry : this.variableVersionsPerCP.get(variableNum).entrySet()) {
                VersionedValueList<Object> list = entry.getValue().getVersionsLow();
                writer.write("Variable '" + entry.getKey() + "' : " + list.toString() + "\n");
            }
        }
        return writer.toString();
    }

    @Override
    public Map<String, VariableReader> getVariableReadersNonCP() {
        HashMap<String, VariableReader> result = new HashMap<String, VariableReader>();
        for (Map.Entry<String, VariableMetaData> entryMeta : this.variables.entrySet()) {
            int variableNum = entryMeta.getValue().getVariableNumber();
            if (entryMeta.getValue().getContextPartitionName() != null) continue;
            for (Map.Entry<Integer, VariableReader> entry : this.variableVersionsPerCP.get(variableNum).entrySet()) {
                result.put(entryMeta.getKey(), entry.getValue());
            }
        }
        return result;
    }

    @Override
    public ConcurrentHashMap<Integer, VariableReader> getReadersPerCP(String variableName) {
        VariableMetaData metaData = this.variables.get(variableName);
        return this.variableVersionsPerCP.get(metaData.getVariableNumber());
    }

    private static VariableTypeException getVariableTypeException(String variableName, Class variableType, Class initValueClass) {
        return new VariableTypeException("Variable '" + variableName + "' of declared type " + JavaClassHelper.getClassNameFullyQualPretty(variableType) + " cannot be initialized by a value of type " + JavaClassHelper.getClassNameFullyQualPretty(initValueClass));
    }
}

