/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.visitor.ExprNodeIdentifierVisitor;
import com.espertech.esper.epl.expression.visitor.ExprNodeVariableVisitor;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.variable.VariableReadWritePackage;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputConditionExpression;
import com.espertech.esper.epl.view.OutputConditionExpressionTypeUtil;
import com.espertech.esper.epl.view.OutputConditionFactory;
import com.espertech.esper.event.EventAdapterService;
import java.util.List;
import java.util.Set;

public class OutputConditionExpressionFactory
implements OutputConditionFactory {
    private final ExprEvaluator whenExpressionNodeEval;
    private final ExprEvaluator andWhenTerminatedExpressionNodeEval;
    private final VariableReadWritePackage variableReadWritePackage;
    private final VariableReadWritePackage variableReadWritePackageAfterTerminated;
    private final Set<String> variableNames;
    protected final boolean isStartConditionOnCreation;
    private EventType builtinPropertiesEventType;

    public OutputConditionExpressionFactory(ExprNode whenExpressionNode, List<OnTriggerSetAssignment> assignments, StatementContext statementContext, ExprNode andWhenTerminatedExpr, List<OnTriggerSetAssignment> afterTerminateAssignments, boolean isStartConditionOnCreation) throws ExprValidationException {
        this.whenExpressionNodeEval = whenExpressionNode.getExprEvaluator();
        this.andWhenTerminatedExpressionNodeEval = andWhenTerminatedExpr != null ? andWhenTerminatedExpr.getExprEvaluator() : null;
        this.isStartConditionOnCreation = isStartConditionOnCreation;
        ExprNodeVariableVisitor variableVisitor = new ExprNodeVariableVisitor();
        whenExpressionNode.accept(variableVisitor);
        this.variableNames = variableVisitor.getVariableNames();
        boolean containsBuiltinProperties = this.containsBuiltinProperties(whenExpressionNode);
        if (!containsBuiltinProperties && assignments != null) {
            for (OnTriggerSetAssignment assignment : assignments) {
                if (!this.containsBuiltinProperties(assignment.getExpression())) continue;
                containsBuiltinProperties = true;
            }
        }
        if (!containsBuiltinProperties && this.andWhenTerminatedExpressionNodeEval != null) {
            containsBuiltinProperties = this.containsBuiltinProperties(andWhenTerminatedExpr);
        }
        if (!containsBuiltinProperties && afterTerminateAssignments != null) {
            for (OnTriggerSetAssignment assignment : afterTerminateAssignments) {
                if (!this.containsBuiltinProperties(assignment.getExpression())) continue;
                containsBuiltinProperties = true;
            }
        }
        if (containsBuiltinProperties) {
            this.builtinPropertiesEventType = OutputConditionExpressionFactory.getBuiltInEventType(statementContext.getEventAdapterService());
        }
        this.variableReadWritePackage = assignments != null ? new VariableReadWritePackage(assignments, statementContext.getVariableService(), statementContext.getEventAdapterService()) : null;
        this.variableReadWritePackageAfterTerminated = afterTerminateAssignments != null ? new VariableReadWritePackage(afterTerminateAssignments, statementContext.getVariableService(), statementContext.getEventAdapterService()) : null;
    }

    @Override
    public OutputCondition make(AgentInstanceContext agentInstanceContext, OutputCallback outputCallback) {
        return new OutputConditionExpression(outputCallback, agentInstanceContext, this, this.isStartConditionOnCreation);
    }

    public ExprEvaluator getWhenExpressionNodeEval() {
        return this.whenExpressionNodeEval;
    }

    public ExprEvaluator getAndWhenTerminatedExpressionNodeEval() {
        return this.andWhenTerminatedExpressionNodeEval;
    }

    public VariableReadWritePackage getVariableReadWritePackage() {
        return this.variableReadWritePackage;
    }

    public VariableReadWritePackage getVariableReadWritePackageAfterTerminated() {
        return this.variableReadWritePackageAfterTerminated;
    }

    public EventType getBuiltinPropertiesEventType() {
        return this.builtinPropertiesEventType;
    }

    public Set<String> getVariableNames() {
        return this.variableNames;
    }

    public static EventType getBuiltInEventType(EventAdapterService eventAdapterService) {
        return eventAdapterService.createAnonymousObjectArrayType(OutputConditionExpressionFactory.class.getName(), OutputConditionExpressionTypeUtil.TYPEINFO);
    }

    private boolean containsBuiltinProperties(ExprNode expr) {
        ExprNodeIdentifierVisitor propertyVisitor = new ExprNodeIdentifierVisitor(false);
        expr.accept(propertyVisitor);
        return !propertyVisitor.getExprProperties().isEmpty();
    }
}

