/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.epl.view.OutputConditionPolledCrontabState;
import com.espertech.esper.epl.view.OutputConditionPolledState;
import com.espertech.esper.schedule.ScheduleComputeHelper;
import com.espertech.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OutputConditionPolledCrontab
implements OutputConditionPolled {
    private final AgentInstanceContext agentInstanceContext;
    private final OutputConditionPolledCrontabState state;
    private static final Log log = LogFactory.getLog(OutputConditionPolledCrontab.class);

    public OutputConditionPolledCrontab(AgentInstanceContext agentInstanceContext, OutputConditionPolledCrontabState state) {
        this.agentInstanceContext = agentInstanceContext;
        this.state = state;
    }

    @Override
    public OutputConditionPolledState getState() {
        return this.state;
    }

    @Override
    public final boolean updateOutputCondition(int newEventsCount, int oldEventsCount) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".updateOutputCondition,   newEventsCount==" + newEventsCount + "  oldEventsCount==" + oldEventsCount));
        }
        boolean output = false;
        long currentTime = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        if (this.state.getCurrentReferencePoint() == null) {
            this.state.setCurrentReferencePoint(currentTime);
            this.state.setNextScheduledTime(ScheduleComputeHelper.computeNextOccurance(this.state.getScheduleSpec(), currentTime, this.agentInstanceContext.getStatementContext().getMethodResolutionService().getEngineImportService().getTimeZone()));
            output = true;
        }
        if (this.state.getNextScheduledTime() <= currentTime) {
            this.state.setNextScheduledTime(ScheduleComputeHelper.computeNextOccurance(this.state.getScheduleSpec(), currentTime, this.agentInstanceContext.getStatementContext().getMethodResolutionService().getEngineImportService().getTimeZone()));
            output = true;
        }
        return output;
    }
}

