/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.epl.view.OutputConditionPolledFactory;
import com.espertech.esper.epl.view.OutputConditionPolledState;
import com.espertech.esper.epl.view.OutputConditionPolledTime;
import com.espertech.esper.epl.view.OutputConditionPolledTimeState;

public final class OutputConditionPolledTimeFactory
implements OutputConditionPolledFactory {
    private final ExprTimePeriod timePeriod;

    public OutputConditionPolledTimeFactory(ExprTimePeriod timePeriod, StatementContext statementContext) {
        this.timePeriod = timePeriod;
        double numSeconds = timePeriod.evaluateAsSeconds(null, true, new ExprEvaluatorContextStatement(statementContext, false));
        if (numSeconds < 0.001 && !timePeriod.hasVariable()) {
            throw new IllegalArgumentException("Output condition by time requires a interval size of at least 1 msec or a variable");
        }
    }

    @Override
    public OutputConditionPolled makeNew(AgentInstanceContext agentInstanceContext) {
        return new OutputConditionPolledTime(this, agentInstanceContext, new OutputConditionPolledTimeState(null));
    }

    @Override
    public OutputConditionPolled makeFromState(AgentInstanceContext agentInstanceContext, OutputConditionPolledState state) {
        OutputConditionPolledTimeState timeState = (OutputConditionPolledTimeState)state;
        return new OutputConditionPolledTime(this, agentInstanceContext, timeState);
    }

    public ExprTimePeriod getTimePeriod() {
        return this.timePeriod;
    }
}

