/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorHelperFactory;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputProcessViewBaseWAfter;
import com.espertech.esper.epl.view.OutputProcessViewConditionDeltaSet;
import com.espertech.esper.epl.view.OutputProcessViewConditionFactory;
import com.espertech.esper.epl.view.OutputStrategyUtil;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputProcessViewConditionDefault
extends OutputProcessViewBaseWAfter {
    private final OutputProcessViewConditionFactory parent;
    private final OutputCondition outputCondition;
    private final OutputProcessViewConditionDeltaSet deltaSet;
    private static final Log log = LogFactory.getLog(OutputProcessViewConditionDefault.class);

    public OutputProcessViewConditionDefault(ResultSetProcessorHelperFactory resultSetProcessorHelperFactory, ResultSetProcessor resultSetProcessor, Long afterConditionTime, Integer afterConditionNumberOfEvents, boolean afterConditionSatisfied, OutputProcessViewConditionFactory parent, AgentInstanceContext agentInstanceContext, boolean isJoin) {
        super(resultSetProcessorHelperFactory, agentInstanceContext, resultSetProcessor, afterConditionTime, afterConditionNumberOfEvents, afterConditionSatisfied);
        this.parent = parent;
        OutputCallback outputCallback = this.getCallbackToLocal(parent.getStreamCount());
        this.outputCondition = parent.getOutputConditionFactory().make(agentInstanceContext, outputCallback);
        this.deltaSet = resultSetProcessorHelperFactory.makeOutputConditionChangeSet(isJoin, agentInstanceContext);
    }

    @Override
    public int getNumChangesetRows() {
        return this.deltaSet.getNumChangesetRows();
    }

    @Override
    public OutputCondition getOptionalOutputCondition() {
        return this.outputCondition;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length)));
        }
        if (this.parent.isHasAfter()) {
            boolean afterSatisfied = super.checkAfterCondition(newData, this.parent.getStatementContext());
            if (!afterSatisfied) {
                if (!this.parent.isUnaggregatedUngrouped()) {
                    this.deltaSet.addView(new UniformPair<EventBean[]>(newData, oldData));
                }
                return;
            }
            this.deltaSet.addView(new UniformPair<EventBean[]>(newData, oldData));
        } else {
            this.deltaSet.addView(new UniformPair<EventBean[]>(newData, oldData));
        }
        int newDataLength = 0;
        int oldDataLength = 0;
        if (newData != null) {
            newDataLength = newData.length;
        }
        if (oldData != null) {
            oldDataLength = oldData.length;
        }
        this.outputCondition.updateOutputCondition(newDataLength, oldDataLength);
    }

    @Override
    public void process(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, ExprEvaluatorContext exprEvaluatorContext) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".process Received update,   newData.length==" + (newEvents == null ? 0 : newEvents.size()) + "  oldData.length==" + (oldEvents == null ? 0 : oldEvents.size())));
        }
        if (this.parent.isHasAfter()) {
            boolean afterSatisfied = super.checkAfterCondition(newEvents, this.parent.getStatementContext());
            if (!afterSatisfied) {
                if (!this.parent.isUnaggregatedUngrouped()) {
                    OutputProcessViewConditionDefault.addToChangeset(newEvents, oldEvents, this.deltaSet);
                }
                return;
            }
            OutputProcessViewConditionDefault.addToChangeset(newEvents, oldEvents, this.deltaSet);
        } else {
            OutputProcessViewConditionDefault.addToChangeset(newEvents, oldEvents, this.deltaSet);
        }
        int newEventsSize = 0;
        if (newEvents != null) {
            newEventsSize = newEvents.size();
        }
        int oldEventsSize = 0;
        if (oldEvents != null) {
            oldEventsSize = oldEvents.size();
        }
        this.outputCondition.updateOutputCondition(newEventsSize, oldEventsSize);
    }

    protected void continueOutputProcessingView(boolean doOutput, boolean forceUpdate) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)".continueOutputProcessingView");
        }
        boolean isGenerateSynthetic = this.parent.getStatementResultService().isMakeSynthetic();
        boolean isGenerateNatural = this.parent.getStatementResultService().isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processOutputLimitedView(this.deltaSet.getViewEventsSet(), isGenerateSynthetic, this.parent.getOutputLimitLimitType());
        if (this.parent.isDistinct() && newOldEvents != null) {
            newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.parent.getEventBeanReader()));
            newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.parent.getEventBeanReader()));
        }
        if (!isGenerateSynthetic && !isGenerateNatural) {
            if (AuditPath.isAuditEnabled) {
                OutputStrategyUtil.indicateEarlyReturn(this.parent.getStatementContext(), newOldEvents);
            }
            this.resetEventBatches();
            return;
        }
        if (doOutput) {
            this.output(forceUpdate, newOldEvents);
        }
        this.resetEventBatches();
    }

    protected void output(boolean forceUpdate, UniformPair<EventBean[]> results) {
        if (this.childView != null) {
            OutputStrategyUtil.output(forceUpdate, results, this.childView);
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.deltaSet.destroy();
        this.outputCondition.stop();
    }

    private void resetEventBatches() {
        this.deltaSet.clear();
    }

    protected void continueOutputProcessingJoin(boolean doOutput, boolean forceUpdate) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)".continueOutputProcessingJoin");
        }
        boolean isGenerateSynthetic = this.parent.getStatementResultService().isMakeSynthetic();
        boolean isGenerateNatural = this.parent.getStatementResultService().isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processOutputLimitedJoin(this.deltaSet.getJoinEventsSet(), isGenerateSynthetic, this.parent.getOutputLimitLimitType());
        if (this.parent.isDistinct() && newOldEvents != null) {
            newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.parent.getEventBeanReader()));
            newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.parent.getEventBeanReader()));
        }
        if (!isGenerateSynthetic && !isGenerateNatural) {
            if (AuditPath.isAuditEnabled) {
                OutputStrategyUtil.indicateEarlyReturn(this.parent.getStatementContext(), newOldEvents);
            }
            this.resetEventBatches();
            return;
        }
        if (doOutput) {
            this.output(forceUpdate, newOldEvents);
        }
        this.resetEventBatches();
    }

    private OutputCallback getCallbackToLocal(int streamCount) {
        if (streamCount == 1) {
            return new OutputCallback(){

                @Override
                public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                    OutputProcessViewConditionDefault.this.continueOutputProcessingView(doOutput, forceUpdate);
                }
            };
        }
        return new OutputCallback(){

            @Override
            public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                OutputProcessViewConditionDefault.this.continueOutputProcessingJoin(doOutput, forceUpdate);
            }
        };
    }

    @Override
    public Iterator<EventBean> iterator() {
        return OutputStrategyUtil.getIterator(this.joinExecutionStrategy, this.resultSetProcessor, this.parentView, this.parent.isDistinct());
    }

    @Override
    public void terminated() {
        if (this.parent.isTerminable()) {
            this.outputCondition.terminated();
        }
    }

    private static void addToChangeset(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, OutputProcessViewConditionDeltaSet joinEventsSet) {
        LinkedHashSet<Object> copyNew = newEvents != null ? new LinkedHashSet<MultiKey<EventBean>>(newEvents) : new LinkedHashSet();
        LinkedHashSet<Object> copyOld = oldEvents != null ? new LinkedHashSet<MultiKey<EventBean>>(oldEvents) : new LinkedHashSet();
        joinEventsSet.addJoin(new UniformPair<Set<MultiKey<EventBean>>>(copyNew, copyOld));
    }
}

