/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.EventDistinctIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StatementResultListener;
import com.espertech.esper.core.service.UpdateDispatchView;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.join.base.JoinExecutionStrategy;
import com.espertech.esper.view.Viewable;
import java.util.Iterator;
import java.util.Set;

public class OutputStrategyUtil {
    public static void output(boolean forceUpdate, UniformPair<EventBean[]> result, UpdateDispatchView finalView) {
        EventBean[] oldEvents;
        EventBean[] newEvents = result != null ? result.getFirst() : null;
        EventBean[] eventBeanArray = oldEvents = result != null ? result.getSecond() : null;
        if (newEvents != null || oldEvents != null) {
            finalView.newResult(result);
        } else if (forceUpdate) {
            finalView.newResult(result);
        }
    }

    public static void indicateEarlyReturn(StatementContext statementContext, UniformPair<EventBean[]> newOldEvents) {
        if (newOldEvents == null) {
            return;
        }
        if (statementContext.getMetricReportingService() != null && statementContext.getMetricReportingService().getStatementOutputHooks() != null && !statementContext.getMetricReportingService().getStatementOutputHooks().isEmpty()) {
            for (StatementResultListener listener : statementContext.getMetricReportingService().getStatementOutputHooks()) {
                listener.update(newOldEvents.getFirst(), newOldEvents.getSecond(), statementContext.getStatementName(), null, null);
            }
        }
    }

    public static Iterator<EventBean> getIterator(JoinExecutionStrategy joinExecutionStrategy, ResultSetProcessor resultSetProcessor, Viewable parentView, boolean distinct) {
        EventType eventType;
        Iterator<EventBean> iterator;
        if (joinExecutionStrategy != null) {
            Set<MultiKey<EventBean>> joinSet = joinExecutionStrategy.staticJoin();
            iterator = resultSetProcessor.getIterator(joinSet);
            eventType = resultSetProcessor.getResultEventType();
        } else if (resultSetProcessor != null) {
            iterator = resultSetProcessor.getIterator(parentView);
            eventType = resultSetProcessor.getResultEventType();
        } else {
            iterator = parentView.iterator();
            eventType = parentView.getEventType();
        }
        if (!distinct) {
            return iterator;
        }
        return new EventDistinctIterator(iterator, eventType);
    }
}

