/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventSender;
import com.espertech.esper.core.service.EPRuntimeEventSender;
import com.espertech.esper.core.thread.InboundUnitSendWrapped;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.map.MapEventType;
import java.util.Map;

public class EventSenderMap
implements EventSender {
    private final EPRuntimeEventSender runtimeEventSender;
    private final EventAdapterService eventAdapterService;
    private final MapEventType mapEventType;
    private final ThreadingService threadingService;

    public EventSenderMap(EPRuntimeEventSender runtimeEventSender, MapEventType mapEventType, EventAdapterService eventAdapterService, ThreadingService threadingService) {
        this.runtimeEventSender = runtimeEventSender;
        this.mapEventType = mapEventType;
        this.threadingService = threadingService;
        this.eventAdapterService = eventAdapterService;
    }

    @Override
    public void sendEvent(Object theEvent) {
        if (!(theEvent instanceof Map)) {
            throw new EPException("Unexpected event object of type " + theEvent.getClass().getName() + ", expected " + Map.class.getName());
        }
        Map map = (Map)theEvent;
        EventBean mapEvent = this.eventAdapterService.adapterForTypedMap(map, this.mapEventType);
        if (ThreadingOption.isThreadingEnabled && this.threadingService.isInboundThreading()) {
            this.threadingService.submitInbound(new InboundUnitSendWrapped(mapEvent, this.runtimeEventSender));
        } else {
            this.runtimeEventSender.processWrappedEvent(mapEvent);
        }
    }

    @Override
    public void route(Object theEvent) {
        if (!(theEvent instanceof Map)) {
            throw new EPException("Unexpected event object of type " + theEvent.getClass().getName() + ", expected " + Map.class.getName());
        }
        Map map = (Map)theEvent;
        EventBean mapEvent = this.eventAdapterService.adapterForTypedMap(map, this.mapEventType);
        this.runtimeEventSender.routeEventBean(mapEvent);
    }
}

