/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import java.util.LinkedHashSet;
import java.util.Set;

public class EventTypeMetadata {
    private final String publicName;
    private final String primaryName;
    private final Set<String> optionalSecondaryNames;
    private final TypeClass typeClass;
    private final boolean isApplicationPreConfiguredStatic;
    private final boolean isApplicationPreConfigured;
    private final boolean isApplicationConfigured;
    private final ApplicationType optionalApplicationType;
    private final boolean isPropertyAgnostic;

    protected EventTypeMetadata(String primaryName, Set<String> secondaryNames, TypeClass typeClass, boolean isApplicationPreConfiguredStatic, boolean applicationPreConfigured, boolean applicationConfigured, ApplicationType applicationType, boolean isPropertyAgnostic) {
        this.publicName = primaryName;
        this.primaryName = primaryName;
        this.optionalSecondaryNames = secondaryNames;
        this.typeClass = typeClass;
        this.isApplicationConfigured = applicationConfigured;
        this.isApplicationPreConfigured = applicationPreConfigured;
        this.isApplicationPreConfiguredStatic = isApplicationPreConfiguredStatic;
        this.optionalApplicationType = applicationType;
        this.isPropertyAgnostic = isPropertyAgnostic;
    }

    public static EventTypeMetadata createValueAdd(String name, TypeClass typeClass) {
        if (typeClass != TypeClass.VARIANT && typeClass != TypeClass.REVISION) {
            throw new IllegalArgumentException("Type class " + (Object)((Object)typeClass) + " invalid");
        }
        return new EventTypeMetadata(name, null, typeClass, true, true, true, null, false);
    }

    public static EventTypeMetadata createBeanType(String name, Class clazz, boolean isPreConfiguredStatic, boolean isPreConfigured, boolean isConfigured, TypeClass typeClass) {
        LinkedHashSet<String> secondaryNames = null;
        if (name == null) {
            name = clazz.getName();
        } else if (!name.equals(clazz.getName())) {
            secondaryNames = new LinkedHashSet<String>();
            secondaryNames.add(clazz.getName());
        }
        return new EventTypeMetadata(name, secondaryNames, typeClass, isPreConfiguredStatic, isPreConfigured, isConfigured, ApplicationType.CLASS, false);
    }

    public static EventTypeMetadata createXMLType(String name, boolean isPreconfiguredStatic, boolean isPropertyAgnostic) {
        return new EventTypeMetadata(name, null, TypeClass.APPLICATION, isPreconfiguredStatic, true, true, ApplicationType.XML, isPropertyAgnostic);
    }

    public static EventTypeMetadata createAnonymous(String associationName) {
        return new EventTypeMetadata(associationName, null, TypeClass.ANONYMOUS, false, false, false, null, false);
    }

    public static EventTypeMetadata createTable(String tableName) {
        return new EventTypeMetadata(tableName, null, TypeClass.TABLE, false, false, false, null, false);
    }

    public static EventTypeMetadata createWrapper(String eventTypeName, boolean namedWindow, boolean insertInto, boolean isPropertyAgnostic) {
        TypeClass typeClass;
        if (namedWindow) {
            typeClass = TypeClass.NAMED_WINDOW;
        } else if (insertInto) {
            typeClass = TypeClass.STREAM;
        } else {
            throw new IllegalStateException("Unknown Wrapper type, cannot create metadata");
        }
        return new EventTypeMetadata(eventTypeName, null, typeClass, false, false, false, null, isPropertyAgnostic);
    }

    public static EventTypeMetadata createNonPojoApplicationType(ApplicationType providedType, String name, boolean preconfiguredStatic, boolean preconfigured, boolean configured, boolean namedWindow, boolean insertInto) {
        TypeClass typeClass;
        ApplicationType applicationType = null;
        if (configured) {
            typeClass = TypeClass.APPLICATION;
            applicationType = providedType;
        } else {
            typeClass = namedWindow ? TypeClass.NAMED_WINDOW : (insertInto ? TypeClass.STREAM : TypeClass.ANONYMOUS);
        }
        return new EventTypeMetadata(name, null, typeClass, preconfiguredStatic, preconfigured, configured, applicationType, false);
    }

    public String getPrimaryName() {
        return this.primaryName;
    }

    public Set<String> getOptionalSecondaryNames() {
        return this.optionalSecondaryNames;
    }

    public TypeClass getTypeClass() {
        return this.typeClass;
    }

    public boolean isApplicationConfigured() {
        return this.isApplicationConfigured;
    }

    public ApplicationType getOptionalApplicationType() {
        return this.optionalApplicationType;
    }

    public String getPublicName() {
        return this.publicName;
    }

    public boolean isPropertyAgnostic() {
        return this.isPropertyAgnostic;
    }

    public boolean isApplicationPreConfigured() {
        return this.isApplicationPreConfigured;
    }

    public boolean isApplicationPreConfiguredStatic() {
        return this.isApplicationPreConfiguredStatic;
    }

    public static enum ApplicationType {
        XML,
        MAP,
        OBJECTARR,
        CLASS;

    }

    public static enum TypeClass {
        STREAM(true),
        REVISION(true),
        VARIANT(true),
        APPLICATION(true),
        NAMED_WINDOW(true),
        TABLE(false),
        ANONYMOUS(false);

        private boolean isPublic;

        public boolean isPublic() {
            return this.isPublic;
        }

        private TypeClass(boolean isPublic) {
            this.isPublic = isPublic;
        }
    }
}

