/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.arr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.BaseNestableEventUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.arr.ObjectArrayEventPropertyGetter;
import com.espertech.esper.event.bean.BeanEventType;

public class ObjectArrayEntryPropertyGetter
implements ObjectArrayEventPropertyGetter {
    private final int propertyIndex;
    private final EventAdapterService eventAdapterService;
    private final BeanEventType eventType;

    public ObjectArrayEntryPropertyGetter(int propertyIndex, BeanEventType eventType, EventAdapterService eventAdapterService) {
        this.propertyIndex = propertyIndex;
        this.eventAdapterService = eventAdapterService;
        this.eventType = eventType;
    }

    @Override
    public Object getObjectArray(Object[] array) throws PropertyAccessException {
        return array[this.propertyIndex];
    }

    @Override
    public boolean isObjectArrayExistsProperty(Object[] array) {
        return true;
    }

    @Override
    public Object get(EventBean obj) {
        Object[] arr = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(obj);
        return this.getObjectArray(arr);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        if (this.eventType == null) {
            return null;
        }
        Object result = this.get(eventBean);
        return BaseNestableEventUtil.getFragmentPojo(result, this.eventType, this.eventAdapterService);
    }
}

