/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.arr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.ObjectArrayBackedEventBean;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ObjectArrayEventBeanCopyMethodWithArrayMap
implements EventBeanCopyMethod {
    private final ObjectArrayEventType eventType;
    private final EventAdapterService eventAdapterService;
    private final Set<Integer> mapIndexesToCopy;
    private final Set<Integer> arrayIndexesToCopy;

    public ObjectArrayEventBeanCopyMethodWithArrayMap(ObjectArrayEventType eventType, EventAdapterService eventAdapterService, Set<String> mapPropertiesToCopy, Set<String> arrayPropertiesToCopy, Map<String, Integer> propertiesIndexes) {
        Integer index;
        this.eventType = eventType;
        this.eventAdapterService = eventAdapterService;
        this.mapIndexesToCopy = new HashSet<Integer>();
        for (String prop : mapPropertiesToCopy) {
            index = propertiesIndexes.get(prop);
            if (index == null) continue;
            this.mapIndexesToCopy.add(index);
        }
        this.arrayIndexesToCopy = new HashSet<Integer>();
        for (String prop : arrayPropertiesToCopy) {
            index = propertiesIndexes.get(prop);
            if (index == null) continue;
            this.arrayIndexesToCopy.add(index);
        }
    }

    @Override
    public EventBean copy(EventBean theEvent) {
        ObjectArrayBackedEventBean arrayBacked = (ObjectArrayBackedEventBean)theEvent;
        Object[] props = arrayBacked.getProperties();
        Object[] shallowCopy = new Object[props.length];
        System.arraycopy(props, 0, shallowCopy, 0, props.length);
        for (int index : this.mapIndexesToCopy) {
            HashMap copy;
            Map innerMap = (Map)shallowCopy[index];
            if (innerMap == null) continue;
            shallowCopy[index] = copy = new HashMap(innerMap);
        }
        for (int index : this.arrayIndexesToCopy) {
            Object array = shallowCopy[index];
            if (array == null || !array.getClass().isArray() || Array.getLength(array) == 0) continue;
            Object copied = Array.newInstance(array.getClass().getComponentType(), Array.getLength(array));
            System.arraycopy(array, 0, copied, 0, Array.getLength(array));
            shallowCopy[index] = copied;
        }
        return this.eventAdapterService.adapterForTypedObjectArray(shallowCopy, this.eventType);
    }
}

