/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationEventTypeLegacy;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeIdGenerator;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.bean.BeanEventTypeFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BeanEventAdapter
implements BeanEventTypeFactory {
    private final ConcurrentHashMap<Class, BeanEventType> typesPerJavaBean;
    private final Lock typesPerJavaBeanLock;
    private final EventAdapterService eventAdapterService;
    private final EventTypeIdGenerator eventTypeIdGenerator;
    private Map<String, ConfigurationEventTypeLegacy> classToLegacyConfigs;
    private Configuration.PropertyResolutionStyle defaultPropertyResolutionStyle;
    private ConfigurationEventTypeLegacy.AccessorStyle defaultAccessorStyle = ConfigurationEventTypeLegacy.AccessorStyle.JAVABEAN;

    public BeanEventAdapter(ConcurrentHashMap<Class, BeanEventType> typesPerJavaBean, EventAdapterService eventAdapterService, EventTypeIdGenerator eventTypeIdGenerator) {
        this.typesPerJavaBean = typesPerJavaBean;
        this.typesPerJavaBeanLock = new ReentrantLock();
        this.classToLegacyConfigs = new HashMap<String, ConfigurationEventTypeLegacy>();
        this.defaultPropertyResolutionStyle = Configuration.PropertyResolutionStyle.getDefault();
        this.eventAdapterService = eventAdapterService;
        this.eventTypeIdGenerator = eventTypeIdGenerator;
    }

    @Override
    public BeanEventType[] getCachedTypes() {
        Collection<BeanEventType> types = this.typesPerJavaBean.values();
        return types.toArray(new BeanEventType[types.size()]);
    }

    public void setDefaultAccessorStyle(ConfigurationEventTypeLegacy.AccessorStyle defaultAccessorStyle) {
        this.defaultAccessorStyle = defaultAccessorStyle;
    }

    public void setClassToLegacyConfigs(Map<String, ConfigurationEventTypeLegacy> classToLegacyConfigs) {
        this.classToLegacyConfigs.putAll(classToLegacyConfigs);
    }

    public void setDefaultPropertyResolutionStyle(Configuration.PropertyResolutionStyle defaultPropertyResolutionStyle) {
        this.defaultPropertyResolutionStyle = defaultPropertyResolutionStyle;
    }

    @Override
    public Configuration.PropertyResolutionStyle getDefaultPropertyResolutionStyle() {
        return this.defaultPropertyResolutionStyle;
    }

    @Override
    public final BeanEventType createBeanTypeDefaultName(Class clazz) {
        return this.createBeanType(clazz.getName(), clazz, false, false, false);
    }

    @Override
    public final BeanEventType createBeanType(String name, Class clazz, boolean isPreconfiguredStatic, boolean isPreconfigured, boolean isConfigured) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null value passed as class");
        }
        BeanEventType eventType = null;
        this.typesPerJavaBeanLock.lock();
        try {
            eventType = this.typesPerJavaBean.get(clazz);
            if (eventType != null) {
                this.eventTypeIdGenerator.assignedType(name, eventType);
                BeanEventType beanEventType = eventType;
                return beanEventType;
            }
            ConfigurationEventTypeLegacy legacyDef = this.classToLegacyConfigs.get(clazz.getName());
            if (legacyDef == null && this.defaultAccessorStyle != ConfigurationEventTypeLegacy.AccessorStyle.JAVABEAN) {
                legacyDef = new ConfigurationEventTypeLegacy();
                legacyDef.setAccessorStyle(this.defaultAccessorStyle);
            }
            int typeId = this.eventTypeIdGenerator.getTypeId(name);
            EventTypeMetadata metadata = EventTypeMetadata.createBeanType(name, clazz, isPreconfiguredStatic, isPreconfigured, isConfigured, EventTypeMetadata.TypeClass.APPLICATION);
            eventType = new BeanEventType(metadata, typeId, clazz, this.eventAdapterService, legacyDef);
            this.typesPerJavaBean.put(clazz, eventType);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.typesPerJavaBeanLock.unlock();
        }
        return eventType;
    }

    public ConfigurationEventTypeLegacy getClassToLegacyConfigs(String className) {
        return this.classToLegacyConfigs.get(className);
    }
}

