/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.BaseNestableEventUtil;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import com.espertech.esper.event.map.MapEventPropertyGetterAndMapped;
import java.util.Map;

public class MapMappedPropertyGetter
implements MapEventPropertyGetter,
MapEventPropertyGetterAndMapped {
    private final String key;
    private final String fieldName;

    public MapMappedPropertyGetter(String fieldName, String key) {
        this.key = key;
        this.fieldName = fieldName;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        return this.getMapInternal(map, this.key);
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        Object value = map.get(this.fieldName);
        return BaseNestableEventUtil.getMappedPropertyExists(value, this.key);
    }

    @Override
    public Object get(EventBean eventBean, String mapKey) throws PropertyAccessException {
        Map<String, Object> data = BaseNestableEventUtil.checkedCastUnderlyingMap(eventBean);
        return this.getMapInternal(data, mapKey);
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Map<String, Object> data = BaseNestableEventUtil.checkedCastUnderlyingMap(eventBean);
        return this.getMap(data);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        Map<String, Object> data = BaseNestableEventUtil.checkedCastUnderlyingMap(eventBean);
        return this.isMapExistsProperty(data);
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        return null;
    }

    private Object getMapInternal(Map<String, Object> map, String providedKey) throws PropertyAccessException {
        Object value = map.get(this.fieldName);
        return BaseNestableEventUtil.getMappedPropertyValue(value, providedKey);
    }
}

