/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.property;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventPropertyType;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.event.arr.ObjectArrayEventPropertyGetter;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.event.arr.ObjectArrayPropertyGetterDefaultObjectArray;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.bean.InternalEventPropDescriptor;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.event.map.MapPropertyGetterDefaultNoFragment;
import com.espertech.esper.event.property.GenericPropertyDesc;
import com.espertech.esper.event.property.PropertyBase;
import com.espertech.esper.event.xml.BaseXMLEventType;
import com.espertech.esper.event.xml.DOMAttributeAndElementGetter;
import com.espertech.esper.event.xml.DOMComplexElementGetter;
import com.espertech.esper.event.xml.DOMSimpleAttributeGetter;
import com.espertech.esper.event.xml.FragmentFactoryDOMGetter;
import com.espertech.esper.event.xml.SchemaElementComplex;
import com.espertech.esper.event.xml.SchemaElementSimple;
import com.espertech.esper.event.xml.SchemaItem;
import com.espertech.esper.event.xml.SchemaItemAttribute;
import com.espertech.esper.event.xml.SchemaUtil;
import java.io.StringWriter;
import java.util.Map;

public class SimpleProperty
extends PropertyBase {
    public SimpleProperty(String propertyName) {
        super(propertyName);
    }

    @Override
    public String[] toPropertyArray() {
        return new String[]{this.getPropertyNameAtomic()};
    }

    @Override
    public EventPropertyGetter getGetter(BeanEventType eventType, EventAdapterService eventAdapterService) {
        InternalEventPropDescriptor propertyDesc = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (propertyDesc == null) {
            return null;
        }
        if (!propertyDesc.getPropertyType().equals((Object)EventPropertyType.SIMPLE)) {
            return null;
        }
        return eventType.getGetter(this.propertyNameAtomic);
    }

    @Override
    public Class getPropertyType(BeanEventType eventType, EventAdapterService eventAdapterService) {
        InternalEventPropDescriptor propertyDesc = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (propertyDesc == null) {
            return null;
        }
        return propertyDesc.getReturnType();
    }

    @Override
    public GenericPropertyDesc getPropertyTypeGeneric(BeanEventType eventType, EventAdapterService eventAdapterService) {
        InternalEventPropDescriptor propertyDesc = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (propertyDesc == null) {
            return null;
        }
        return propertyDesc.getReturnTypeGeneric();
    }

    @Override
    public Class getPropertyTypeMap(Map optionalMapPropTypes, EventAdapterService eventAdapterService) {
        if (optionalMapPropTypes == null) {
            return null;
        }
        Object def = optionalMapPropTypes.get(this.propertyNameAtomic);
        if (def == null) {
            return null;
        }
        if (def instanceof Class) {
            return (Class)def;
        }
        if (def instanceof Map) {
            return Map.class;
        }
        if (def instanceof String) {
            EventType eventType;
            String propertyName = def.toString();
            boolean isArray = EventTypeUtility.isPropertyArray(propertyName);
            if (isArray) {
                propertyName = EventTypeUtility.getPropertyRemoveArray(propertyName);
            }
            if ((eventType = eventAdapterService.getExistsTypeByName(propertyName)) instanceof MapEventType) {
                if (isArray) {
                    return Map[].class;
                }
                return Map.class;
            }
            if (eventType instanceof ObjectArrayEventType) {
                if (isArray) {
                    return Object[][].class;
                }
                return Object[].class;
            }
        }
        String message = "Nestable map type configuration encountered an unexpected value type of '" + def.getClass() + " for property '" + this.propertyNameAtomic + "', expected Map or Class";
        throw new PropertyAccessException(message);
    }

    @Override
    public MapEventPropertyGetter getGetterMap(Map optionalMapPropTypes, EventAdapterService eventAdapterService) {
        if (optionalMapPropTypes == null) {
            return null;
        }
        Object def = optionalMapPropTypes.get(this.propertyNameAtomic);
        if (def == null) {
            return null;
        }
        return new MapPropertyGetterDefaultNoFragment(this.propertyNameAtomic, eventAdapterService);
    }

    @Override
    public void toPropertyEPL(StringWriter writer) {
        writer.append(this.propertyNameAtomic);
    }

    @Override
    public EventPropertyGetter getGetterDOM() {
        return new DOMAttributeAndElementGetter(this.propertyNameAtomic);
    }

    @Override
    public EventPropertyGetter getGetterDOM(SchemaElementComplex complexProperty, EventAdapterService eventAdapterService, BaseXMLEventType xmlEventType, String propertyExpression) {
        for (SchemaItemAttribute attribute : complexProperty.getAttributes()) {
            if (!attribute.getName().equals(this.propertyNameAtomic)) continue;
            return new DOMSimpleAttributeGetter(this.propertyNameAtomic);
        }
        for (SchemaElementSimple simple : complexProperty.getSimpleElements()) {
            if (!simple.getName().equals(this.propertyNameAtomic)) continue;
            return new DOMComplexElementGetter(this.propertyNameAtomic, null, simple.isArray());
        }
        for (SchemaElementComplex complex : complexProperty.getChildren()) {
            FragmentFactoryDOMGetter complexFragmentFactory = new FragmentFactoryDOMGetter(eventAdapterService, xmlEventType, propertyExpression);
            if (!complex.getName().equals(this.propertyNameAtomic)) continue;
            return new DOMComplexElementGetter(this.propertyNameAtomic, complexFragmentFactory, complex.isArray());
        }
        return null;
    }

    @Override
    public SchemaItem getPropertyTypeSchema(SchemaElementComplex complexProperty, EventAdapterService eventAdapterService) {
        return SchemaUtil.findPropertyMapping(complexProperty, this.propertyNameAtomic);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public ObjectArrayEventPropertyGetter getGetterObjectArray(Map<String, Integer> indexPerProperty, Map<String, Object> nestableTypes, EventAdapterService eventAdapterService) {
        if (nestableTypes == null) {
            return null;
        }
        Integer propertyIndex = indexPerProperty.get(this.propertyNameAtomic);
        if (propertyIndex == null) {
            return null;
        }
        return new ObjectArrayPropertyGetterDefaultObjectArray(propertyIndex, null, eventAdapterService);
    }
}

