/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.vaevent;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.event.vaevent.PropertyGroupDesc;
import com.espertech.esper.event.vaevent.RevisionTypeDesc;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyUtility {
    private static final Log log = LogFactory.getLog(PropertyUtility.class);

    public static Object getKeys(EventBean theEvent, EventPropertyGetter[] keyPropertyGetters) {
        if (keyPropertyGetters.length == 1) {
            return keyPropertyGetters[0].get(theEvent);
        }
        Object[] keys = new Object[keyPropertyGetters.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = keyPropertyGetters[i].get(theEvent);
        }
        return new MultiKeyUntyped(keys);
    }

    public static Map<EventType, RevisionTypeDesc> getPerType(PropertyGroupDesc[] groups, String[] changesetProperties, String[] keyProperties) {
        HashMap<EventType, RevisionTypeDesc> perType = new HashMap<EventType, RevisionTypeDesc>();
        for (PropertyGroupDesc group : groups) {
            for (EventType type : group.getTypes().keySet()) {
                EventPropertyGetter[] changesetGetters = PropertyUtility.getGetters(type, changesetProperties);
                EventPropertyGetter[] keyGetters = PropertyUtility.getGetters(type, keyProperties);
                RevisionTypeDesc pair = new RevisionTypeDesc(keyGetters, changesetGetters, group);
                perType.put(type, pair);
            }
        }
        return perType;
    }

    public static Map<String, int[]> getGroupsPerProperty(PropertyGroupDesc[] groups) {
        HashMap<String, int[]> groupsNumsPerProp = new HashMap<String, int[]>();
        for (PropertyGroupDesc group : groups) {
            for (String property : group.getProperties()) {
                int[] value = (int[])groupsNumsPerProp.get(property);
                if (value == null) {
                    value = new int[1];
                    groupsNumsPerProp.put(property, value);
                    value[0] = group.getGroupNum();
                    continue;
                }
                int[] copy = new int[value.length + 1];
                System.arraycopy(value, 0, copy, 0, value.length);
                copy[value.length] = group.getGroupNum();
                Arrays.sort(copy);
                groupsNumsPerProp.put(property, copy);
            }
        }
        return groupsNumsPerProp;
    }

    public static PropertyGroupDesc[] analyzeGroups(String[] allProperties, EventType[] deltaEventTypes, String[] names) {
        if (deltaEventTypes.length != names.length) {
            throw new IllegalArgumentException("Delta event type number and name number of elements don't match");
        }
        allProperties = PropertyUtility.copyAndSort(allProperties);
        LinkedHashMap<MultiKey<String>, PropertyGroupDesc> result = new LinkedHashMap<MultiKey<String>, PropertyGroupDesc>();
        int currentGroupNum = 0;
        for (int i = 0; i < deltaEventTypes.length; ++i) {
            Map<EventType, String> typesForGroup;
            MultiKey<String> props = PropertyUtility.getPropertiesContributed(deltaEventTypes[i], allProperties);
            if (props.getArray().length == 0) {
                log.warn((Object)("Event type named '" + names[i] + "' does not contribute (or override) any properties of the revision event type"));
                continue;
            }
            PropertyGroupDesc propertyGroup = (PropertyGroupDesc)result.get(props);
            if (propertyGroup == null) {
                typesForGroup = new HashMap<EventType, String>();
                propertyGroup = new PropertyGroupDesc(currentGroupNum++, typesForGroup, props.getArray());
                result.put(props, propertyGroup);
            } else {
                typesForGroup = propertyGroup.getTypes();
            }
            typesForGroup.put(deltaEventTypes[i], names[i]);
        }
        Collection outColl = result.values();
        Object[] array = outColl.toArray(new PropertyGroupDesc[outColl.size()]);
        if (log.isDebugEnabled()) {
            log.debug((Object)(".analyzeGroups " + Arrays.toString(array)));
        }
        return array;
    }

    private static MultiKey<String> getPropertiesContributed(EventType deltaEventType, String[] allPropertiesSorted) {
        TreeSet<String> props = new TreeSet<String>();
        block0: for (String property : deltaEventType.getPropertyNames()) {
            for (String propInAll : allPropertiesSorted) {
                if (!propInAll.equals(property)) continue;
                props.add(property);
                continue block0;
            }
        }
        return new MultiKey<String>(props.toArray(new String[props.size()]));
    }

    protected static String[] copyAndSort(String[] input) {
        Object[] result = new String[input.length];
        System.arraycopy(input, 0, result, 0, input.length);
        Arrays.sort(result);
        return result;
    }

    public static EventPropertyGetter[] getGetters(EventType eventType, String[] propertyNames) {
        EventPropertyGetter[] getters = new EventPropertyGetter[propertyNames.length];
        for (int i = 0; i < getters.length; ++i) {
            getters[i] = eventType.getGetter(propertyNames[i]);
        }
        return getters;
    }

    protected static String[] uniqueExclusiveSort(String[] values, String[] removeValues) {
        HashSet<String> unique = new HashSet<String>();
        unique.addAll(Arrays.asList(values));
        for (String removeValue : removeValues) {
            unique.remove(removeValue);
        }
        Object[] uniqueArr = unique.toArray(new String[unique.size()]);
        Arrays.sort(uniqueArr);
        return uniqueArr;
    }

    public static PropertyAccessException getMismatchException(Method method, Object object, ClassCastException e) {
        return PropertyUtility.getMismatchException(method.getDeclaringClass(), object, e);
    }

    public static PropertyAccessException getMismatchException(Field field, Object object, ClassCastException e) {
        return PropertyUtility.getMismatchException(field.getDeclaringClass(), object, e);
    }

    public static PropertyAccessException getInvocationTargetException(Method method, InvocationTargetException e) {
        Class<?> declaring = method.getDeclaringClass();
        String message = "Failed to invoke method " + method.getName() + " on class " + JavaClassHelper.getClassNameFullyQualPretty(declaring) + ": " + e.getTargetException().getMessage();
        throw new PropertyAccessException(message, e);
    }

    public static PropertyAccessException getIllegalAccessException(Field field, IllegalAccessException e) {
        return PropertyUtility.getAccessExceptionField(field, e);
    }

    public static PropertyAccessException getIllegalArgumentException(Field field, IllegalArgumentException e) {
        return PropertyUtility.getAccessExceptionField(field, e);
    }

    private static PropertyAccessException getAccessExceptionField(Field field, Exception e) {
        Class<?> declaring = field.getDeclaringClass();
        String message = "Failed to obtain field value for field " + field.getName() + " on class " + JavaClassHelper.getClassNameFullyQualPretty(declaring) + ": " + e.getMessage();
        throw new PropertyAccessException(message, e);
    }

    private static PropertyAccessException getMismatchException(Class declared, Object object, ClassCastException e) {
        String classNameReceived;
        String classNameExpected = JavaClassHelper.getClassNameFullyQualPretty(declared);
        if (classNameExpected.equals(classNameReceived = object != null ? JavaClassHelper.getClassNameFullyQualPretty(object.getClass()) : "null")) {
            classNameExpected = JavaClassHelper.getClassNameFullyQualPrettyWithClassloader(declared);
            classNameReceived = object != null ? JavaClassHelper.getClassNameFullyQualPrettyWithClassloader(object.getClass()) : "null";
        }
        String message = "Mismatched getter instance to event bean type, expected " + classNameExpected + " but received " + classNameReceived;
        throw new PropertyAccessException(message, e);
    }

    public static PropertyAccessException getIllegalAccessException(Method method, IllegalAccessException e) {
        return PropertyUtility.getAccessExceptionMethod(method, e);
    }

    public static PropertyAccessException getIllegalArgumentException(Method method, IllegalArgumentException e) {
        return PropertyUtility.getAccessExceptionMethod(method, e);
    }

    private static PropertyAccessException getAccessExceptionMethod(Method method, Exception e) {
        Class<?> declaring = method.getDeclaringClass();
        String message = "Failed to invoke method " + method.getName() + " on class " + JavaClassHelper.getClassNameFullyQualPretty(declaring) + ": " + e.getMessage();
        throw new PropertyAccessException(message, e);
    }
}

