/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventType;
import com.espertech.esper.event.BaseConfigurableEventType;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.EventBeanWriter;
import com.espertech.esper.event.EventPropertyWriter;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.event.ExplicitPropertyDescriptor;
import com.espertech.esper.event.xml.FragmentFactoryXPathPredefinedGetter;
import com.espertech.esper.event.xml.SchemaUtil;
import com.espertech.esper.event.xml.XPathNamespaceContext;
import com.espertech.esper.event.xml.XPathPropertyGetter;
import com.espertech.esper.util.ClassInstantiationException;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public abstract class BaseXMLEventType
extends BaseConfigurableEventType {
    private static final Log log = LogFactory.getLog(BaseXMLEventType.class);
    private final XPathFactory xPathFactory;
    private final String rootElementName;
    private final ConfigurationEventTypeXMLDOM configurationEventTypeXMLDOM;
    private String startTimestampPropertyName;
    private String endTimestampPropertyName;
    protected XPathNamespaceContext namespaceContext;

    public BaseXMLEventType(EventTypeMetadata metadata, int eventTypeId, ConfigurationEventTypeXMLDOM configurationEventTypeXMLDOM, EventAdapterService eventAdapterService) {
        super(eventAdapterService, metadata, eventTypeId, Node.class);
        this.rootElementName = configurationEventTypeXMLDOM.getRootElementName();
        this.configurationEventTypeXMLDOM = configurationEventTypeXMLDOM;
        this.xPathFactory = XPathFactory.newInstance();
        if (configurationEventTypeXMLDOM.getXPathFunctionResolver() != null) {
            try {
                XPathFunctionResolver fresolver = (XPathFunctionResolver)JavaClassHelper.instantiate(XPathFunctionResolver.class, configurationEventTypeXMLDOM.getXPathFunctionResolver());
                this.xPathFactory.setXPathFunctionResolver(fresolver);
            }
            catch (ClassInstantiationException ex) {
                throw new ConfigurationException("Error configuring XPath function resolver for XML type '" + configurationEventTypeXMLDOM.getRootElementName() + "' : " + ex.getMessage(), ex);
            }
        }
        if (configurationEventTypeXMLDOM.getXPathVariableResolver() != null) {
            try {
                XPathVariableResolver vresolver = (XPathVariableResolver)JavaClassHelper.instantiate(XPathVariableResolver.class, configurationEventTypeXMLDOM.getXPathVariableResolver());
                this.xPathFactory.setXPathVariableResolver(vresolver);
            }
            catch (ClassInstantiationException ex) {
                throw new ConfigurationException("Error configuring XPath variable resolver for XML type '" + configurationEventTypeXMLDOM.getRootElementName() + "' : " + ex.getMessage(), ex);
            }
        }
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    protected void setNamespaceContext(XPathNamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    protected void initialize(Collection<ConfigurationEventTypeXMLDOM.XPathPropertyDesc> explicitXPathProperties, List<ExplicitPropertyDescriptor> additionalSchemaProperties) {
        LinkedHashMap<String, ExplicitPropertyDescriptor> namedProperties = new LinkedHashMap<String, ExplicitPropertyDescriptor>();
        for (ExplicitPropertyDescriptor desc : additionalSchemaProperties) {
            namedProperties.put(desc.getDescriptor().getPropertyName(), desc);
        }
        String xpathExpression = null;
        try {
            for (ConfigurationEventTypeXMLDOM.XPathPropertyDesc property : explicitXPathProperties) {
                XPath xPath = this.xPathFactory.newXPath();
                if (this.namespaceContext != null) {
                    xPath.setNamespaceContext(this.namespaceContext);
                }
                xpathExpression = property.getXpath();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Compiling XPath expression for property '" + property.getName() + "' as '" + xpathExpression + "'"));
                }
                XPathExpression expression = xPath.compile(xpathExpression);
                FragmentFactoryXPathPredefinedGetter fragmentFactory = null;
                boolean isFragment = false;
                if (property.getOptionaleventTypeName() != null) {
                    fragmentFactory = new FragmentFactoryXPathPredefinedGetter(this.getEventAdapterService(), property.getOptionaleventTypeName(), property.getName());
                    isFragment = true;
                }
                boolean isArray = false;
                if (property.getType().equals(XPathConstants.NODESET)) {
                    isArray = true;
                }
                XPathPropertyGetter getter = new XPathPropertyGetter(property.getName(), xpathExpression, expression, property.getType(), property.getOptionalCastToType(), fragmentFactory);
                Class returnType = SchemaUtil.toReturnType(property.getType(), property.getOptionalCastToType());
                EventPropertyDescriptor desc = new EventPropertyDescriptor(property.getName(), returnType, null, false, false, isArray, false, isFragment);
                ExplicitPropertyDescriptor explicit = new ExplicitPropertyDescriptor(desc, getter, isArray, property.getOptionaleventTypeName());
                namedProperties.put(desc.getPropertyName(), explicit);
            }
        }
        catch (XPathExpressionException ex) {
            throw new EPException("XPath expression could not be compiled for expression '" + xpathExpression + '\'', ex);
        }
        super.initialize(new ArrayList<ExplicitPropertyDescriptor>(namedProperties.values()));
        this.startTimestampPropertyName = this.configurationEventTypeXMLDOM.getStartTimestampPropertyName();
        this.endTimestampPropertyName = this.configurationEventTypeXMLDOM.getEndTimestampPropertyName();
        EventTypeUtility.validateTimestampProperties(this, this.startTimestampPropertyName, this.endTimestampPropertyName);
    }

    protected XPathFactory getXPathFactory() {
        return this.xPathFactory;
    }

    @Override
    public EventType[] getSuperTypes() {
        return null;
    }

    @Override
    public Iterator<EventType> getDeepSuperTypes() {
        return null;
    }

    public ConfigurationEventTypeXMLDOM getConfigurationEventTypeXMLDOM() {
        return this.configurationEventTypeXMLDOM;
    }

    @Override
    public boolean equalsCompareType(EventType eventType) {
        if (!(eventType instanceof BaseXMLEventType)) {
            return false;
        }
        BaseXMLEventType other = (BaseXMLEventType)eventType;
        return this.configurationEventTypeXMLDOM.equals(other.configurationEventTypeXMLDOM);
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof BaseXMLEventType)) {
            return false;
        }
        BaseXMLEventType other = (BaseXMLEventType)otherObj;
        return this.configurationEventTypeXMLDOM.equals(other.configurationEventTypeXMLDOM);
    }

    public int hashCode() {
        return this.configurationEventTypeXMLDOM.hashCode();
    }

    @Override
    public EventPropertyWriter getWriter(String propertyName) {
        return null;
    }

    @Override
    public EventPropertyDescriptor[] getWriteableProperties() {
        return new EventPropertyDescriptor[0];
    }

    @Override
    public EventBeanCopyMethod getCopyMethod(String[] properties) {
        return null;
    }

    @Override
    public EventPropertyDescriptor getWritableProperty(String propertyName) {
        return null;
    }

    @Override
    public EventBeanWriter getWriter(String[] properties) {
        return null;
    }

    @Override
    public EventBeanReader getReader() {
        return null;
    }

    @Override
    public String getStartTimestampPropertyName() {
        return this.startTimestampPropertyName;
    }

    @Override
    public String getEndTimestampPropertyName() {
        return this.endTimestampPropertyName;
    }
}

