/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprNodeAdapterBase {
    private static final Log log = LogFactory.getLog(ExprNodeAdapterBase.class);
    private final int filterSpecId;
    private final int filterSpecParamPathNum;
    protected final ExprNode exprNode;
    protected final ExprEvaluator exprNodeEval;
    protected final ExprEvaluatorContext evaluatorContext;

    public ExprNodeAdapterBase(int filterSpecId, int filterSpecParamPathNum, ExprNode exprNode, ExprEvaluatorContext evaluatorContext) {
        this.filterSpecId = filterSpecId;
        this.filterSpecParamPathNum = filterSpecParamPathNum;
        this.exprNode = exprNode;
        this.exprNodeEval = exprNode.getExprEvaluator();
        this.evaluatorContext = evaluatorContext;
    }

    public boolean evaluate(EventBean theEvent) {
        return this.evaluatePerStream(new EventBean[]{theEvent});
    }

    protected boolean evaluatePerStream(EventBean[] eventsPerStream) {
        try {
            Boolean result = (Boolean)this.exprNodeEval.evaluate(eventsPerStream, true, this.evaluatorContext);
            if (result == null) {
                return false;
            }
            return result;
        }
        catch (RuntimeException ex) {
            log.error((Object)("Error evaluating expression '" + ExprNodeUtility.toExpressionStringMinPrecedenceSafe(this.exprNode) + "' statement '" + this.getStatementName() + "': " + ex.getMessage()), (Throwable)ex);
            return false;
        }
    }

    public String getStatementName() {
        return this.evaluatorContext.getStatementName();
    }

    public int getStatementId() {
        return this.evaluatorContext.getStatementId();
    }

    public ExprNode getExprNode() {
        return this.exprNode;
    }

    public int getFilterSpecId() {
        return this.filterSpecId;
    }

    public int getFilterSpecParamPathNum() {
        return this.filterSpecParamPathNum;
    }

    public ExprEvaluatorContext getEvaluatorContext() {
        return this.evaluatorContext;
    }
}

