/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.ExprNodeAdapterBase;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexBase;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;

public final class FilterParamIndexBooleanExpr
extends FilterParamIndexBase {
    private final Map<ExprNodeAdapterBase, EventEvaluator> evaluatorsMap = new LinkedHashMap<ExprNodeAdapterBase, EventEvaluator>();
    private final ReadWriteLock constantsMapRWLock;

    public FilterParamIndexBooleanExpr(ReadWriteLock readWriteLock) {
        super(FilterOperator.BOOLEAN_EXPRESSION);
        this.constantsMapRWLock = readWriteLock;
    }

    @Override
    public final EventEvaluator get(Object filterConstant) {
        ExprNodeAdapterBase keyValues = (ExprNodeAdapterBase)filterConstant;
        return this.evaluatorsMap.get(keyValues);
    }

    @Override
    public final void put(Object filterConstant, EventEvaluator evaluator) {
        ExprNodeAdapterBase keys = (ExprNodeAdapterBase)filterConstant;
        this.evaluatorsMap.put(keys, evaluator);
    }

    @Override
    public final boolean remove(Object filterConstant) {
        ExprNodeAdapterBase keys = (ExprNodeAdapterBase)filterConstant;
        return this.evaluatorsMap.remove(keys) != null;
    }

    @Override
    public final int size() {
        return this.evaluatorsMap.size();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.constantsMapRWLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void matchEvent(EventBean theEvent, Collection<FilterHandle> matches) {
        this.constantsMapRWLock.readLock().lock();
        try {
            for (Map.Entry<ExprNodeAdapterBase, EventEvaluator> evals : this.evaluatorsMap.entrySet()) {
                if (!evals.getKey().evaluate(theEvent)) continue;
                evals.getValue().matchEvent(theEvent, matches);
            }
        }
        finally {
            this.constantsMapRWLock.readLock().unlock();
        }
    }
}

