/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.filter.DoubleRange;
import com.espertech.esper.filter.DoubleRangeComparator;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexLookupableBase;
import com.espertech.esper.filter.FilterSpecLookupable;
import java.util.IdentityHashMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FilterParamIndexDoubleRangeBase
extends FilterParamIndexLookupableBase {
    protected final TreeMap<DoubleRange, EventEvaluator> ranges;
    private final IdentityHashMap<DoubleRange, EventEvaluator> rangesNullEndpoints;
    private final ReadWriteLock rangesRWLock;
    protected double largestRangeValueDouble = Double.MIN_VALUE;
    private static final Log log = LogFactory.getLog(FilterParamIndexDoubleRangeBase.class);

    protected FilterParamIndexDoubleRangeBase(FilterSpecLookupable lookupable, ReadWriteLock readWriteLock, FilterOperator filterOperator) {
        super(filterOperator, lookupable);
        this.ranges = new TreeMap(new DoubleRangeComparator());
        this.rangesNullEndpoints = new IdentityHashMap();
        this.rangesRWLock = readWriteLock;
    }

    @Override
    public final EventEvaluator get(Object expressionValue) {
        if (!(expressionValue instanceof DoubleRange)) {
            throw new IllegalArgumentException("Supplied expressionValue must be of type DoubleRange");
        }
        DoubleRange range = (DoubleRange)expressionValue;
        if (range.getMax() == null || range.getMin() == null) {
            return this.rangesNullEndpoints.get(range);
        }
        return this.ranges.get(range);
    }

    @Override
    public final void put(Object expressionValue, EventEvaluator matcher) {
        if (!(expressionValue instanceof DoubleRange)) {
            throw new IllegalArgumentException("Supplied expressionValue must be of type DoubleRange");
        }
        DoubleRange range = (DoubleRange)expressionValue;
        if (range.getMax() == null || range.getMin() == null) {
            this.rangesNullEndpoints.put(range, matcher);
            return;
        }
        if (Math.abs(range.getMax() - range.getMin()) > this.largestRangeValueDouble) {
            this.largestRangeValueDouble = Math.abs(range.getMax() - range.getMin());
        }
        this.ranges.put(range, matcher);
    }

    @Override
    public final boolean remove(Object filterConstant) {
        DoubleRange range = (DoubleRange)filterConstant;
        if (range.getMax() == null || range.getMin() == null) {
            return this.rangesNullEndpoints.remove(range) != null;
        }
        return this.ranges.remove(range) != null;
    }

    @Override
    public final int size() {
        return this.ranges.size();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.rangesRWLock;
    }
}

