/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexLookupableBase;
import com.espertech.esper.filter.FilterSpecLookupable;
import com.espertech.esper.filter.StringRange;
import com.espertech.esper.filter.StringRangeComparator;
import java.util.IdentityHashMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FilterParamIndexStringRangeBase
extends FilterParamIndexLookupableBase {
    protected final TreeMap<StringRange, EventEvaluator> ranges = new TreeMap(new StringRangeComparator());
    private final IdentityHashMap<StringRange, EventEvaluator> rangesNullEndpoints = new IdentityHashMap();
    private final ReadWriteLock rangesRWLock;
    private static final Log log = LogFactory.getLog(FilterParamIndexStringRangeBase.class);

    protected FilterParamIndexStringRangeBase(FilterSpecLookupable lookupable, ReadWriteLock readWriteLock, FilterOperator filterOperator) {
        super(filterOperator, lookupable);
        this.rangesRWLock = readWriteLock;
    }

    @Override
    public final EventEvaluator get(Object expressionValue) {
        if (!(expressionValue instanceof StringRange)) {
            throw new IllegalArgumentException("Supplied expressionValue must be of type StringRange");
        }
        StringRange range = (StringRange)expressionValue;
        if (range.getMax() == null || range.getMin() == null) {
            return this.rangesNullEndpoints.get(range);
        }
        return this.ranges.get(range);
    }

    @Override
    public final void put(Object expressionValue, EventEvaluator matcher) {
        if (!(expressionValue instanceof StringRange)) {
            throw new IllegalArgumentException("Supplied expressionValue must be of type DoubleRange");
        }
        StringRange range = (StringRange)expressionValue;
        if (range.getMax() == null || range.getMin() == null) {
            this.rangesNullEndpoints.put(range, matcher);
            return;
        }
        this.ranges.put(range, matcher);
    }

    @Override
    public final boolean remove(Object filterConstant) {
        StringRange range = (StringRange)filterConstant;
        if (range.getMax() == null || range.getMin() == null) {
            return this.rangesNullEndpoints.remove(range) != null;
        }
        return this.ranges.remove(range) != null;
    }

    @Override
    public final int size() {
        return this.ranges.size();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.rangesRWLock;
    }
}

