/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventType;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.filter.FilterValueSetParam;
import java.io.StringWriter;
import java.util.Arrays;

public class FilterValueSetImpl
implements FilterValueSet {
    private final EventType eventType;
    private final FilterValueSetParam[][] parameters;

    public FilterValueSetImpl(EventType eventType, FilterValueSetParam[][] parameters) {
        this.eventType = eventType;
        this.parameters = parameters;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public FilterValueSetParam[][] getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "FilterValueSetImpl{eventType=" + this.eventType.getName() + ", parameters=" + Arrays.toString((Object[])this.parameters) + '}';
    }

    @Override
    public void appendTo(StringWriter writer) {
        writer.append(this.eventType.getName());
        writer.append("(");
        String delimiter = "";
        for (FilterValueSetParam[] param : this.parameters) {
            writer.append(delimiter);
            this.appendTo(writer, param);
            delimiter = " or ";
        }
        writer.append(")");
    }

    private void appendTo(StringWriter writer, FilterValueSetParam[] parameters) {
        String delimiter = "";
        for (FilterValueSetParam param : parameters) {
            writer.append(delimiter);
            param.appendTo(writer);
            delimiter = ",";
        }
    }
}

