/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.pattern.EvalFollowedByNode;
import com.espertech.esper.pattern.EvalFollowedByNodeOpType;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNodeFactoryBase;
import com.espertech.esper.pattern.EvalNodeUtil;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternExpressionPrecedenceEnum;
import com.espertech.esper.pattern.PatternExpressionUtil;
import java.io.StringWriter;
import java.util.List;

public class EvalFollowedByFactoryNode
extends EvalNodeFactoryBase {
    private static final long serialVersionUID = 6255755581326049894L;
    private List<ExprNode> optionalMaxExpressions;
    private boolean hasEngineWidePatternCount;
    protected EvalFollowedByNodeOpType opType;
    private Integer[] cachedMaxPerChild;
    private transient ExprEvaluator[] cachedMaxEvaluatorPerChild;

    protected EvalFollowedByFactoryNode(List<ExprNode> optionalMaxExpressions, boolean hasEngineWidePatternCount) {
        this.optionalMaxExpressions = optionalMaxExpressions;
        this.hasEngineWidePatternCount = hasEngineWidePatternCount;
    }

    @Override
    public EvalNode makeEvalNode(PatternAgentInstanceContext agentInstanceContext, EvalNode parentNode) {
        if (this.opType == null) {
            this.initOpType();
        }
        EvalNode[] children = EvalNodeUtil.makeEvalNodeChildren(this.getChildNodes(), agentInstanceContext, parentNode);
        return new EvalFollowedByNode(agentInstanceContext, this, children);
    }

    public List<ExprNode> getOptionalMaxExpressions() {
        return this.optionalMaxExpressions;
    }

    public void setOptionalMaxExpressions(List<ExprNode> optionalMaxExpressions) {
        this.optionalMaxExpressions = optionalMaxExpressions;
    }

    public final String toString() {
        return "EvalFollowedByNode children=" + this.getChildNodes().size();
    }

    protected void initOpType() {
        boolean hasMax;
        boolean bl = hasMax = this.optionalMaxExpressions != null && !this.optionalMaxExpressions.isEmpty();
        if (!hasMax) {
            this.opType = this.hasEngineWidePatternCount ? EvalFollowedByNodeOpType.NOMAX_POOL : EvalFollowedByNodeOpType.NOMAX_PLAIN;
            return;
        }
        this.cachedMaxPerChild = new Integer[this.getChildNodes().size() - 1];
        this.cachedMaxEvaluatorPerChild = new ExprEvaluator[this.getChildNodes().size() - 1];
        for (int i = 0; i < this.getChildNodes().size() - 1; ++i) {
            ExprNode optionalMaxExpression;
            if (this.optionalMaxExpressions.size() <= i || (optionalMaxExpression = this.optionalMaxExpressions.get(i)) == null) continue;
            if (optionalMaxExpression.isConstantResult()) {
                Number result = (Number)optionalMaxExpression.getExprEvaluator().evaluate(null, true, null);
                if (result == null) continue;
                this.cachedMaxPerChild[i] = result.intValue();
                continue;
            }
            this.cachedMaxEvaluatorPerChild[i] = this.optionalMaxExpressions.get(i).getExprEvaluator();
        }
        this.opType = this.hasEngineWidePatternCount ? EvalFollowedByNodeOpType.MAX_POOL : EvalFollowedByNodeOpType.MAX_PLAIN;
    }

    public EvalFollowedByNodeOpType getOpType() {
        return this.opType;
    }

    public int getMax(int position) {
        Integer cached = this.cachedMaxPerChild[position];
        if (cached != null) {
            return cached;
        }
        ExprEvaluator cachedExpr = this.cachedMaxEvaluatorPerChild[position];
        if (cachedExpr == null) {
            return -1;
        }
        Number result = (Number)cachedExpr.evaluate(null, true, null);
        if (result != null) {
            return result.intValue();
        }
        return -1;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.optionalMaxExpressions == null || this.optionalMaxExpressions.isEmpty()) {
            PatternExpressionUtil.toPrecedenceFreeEPL(writer, "->", this.getChildNodes(), this.getPrecedence());
        } else {
            this.getChildNodes().get(0).toEPL(writer, PatternExpressionPrecedenceEnum.MINIMUM);
            for (int i = 1; i < this.getChildNodes().size(); ++i) {
                ExprNode optionalMaxExpression = null;
                if (this.optionalMaxExpressions.size() > i - 1) {
                    optionalMaxExpression = this.optionalMaxExpressions.get(i - 1);
                }
                if (optionalMaxExpression == null) {
                    writer.append(" -> ");
                } else {
                    writer.append(" -[");
                    writer.append(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(optionalMaxExpression));
                    writer.append("]> ");
                }
                this.getChildNodes().get(i).toEPL(writer, PatternExpressionPrecedenceEnum.MINIMUM);
            }
        }
    }

    @Override
    public PatternExpressionPrecedenceEnum getPrecedence() {
        return PatternExpressionPrecedenceEnum.FOLLOWEDBY;
    }
}

