/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalFactoryNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternExpressionPrecedenceEnum;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EvalNodeFactoryBase
implements EvalFactoryNode,
Serializable {
    private static final Log log = LogFactory.getLog(EvalNodeFactoryBase.class);
    private static final long serialVersionUID = 0L;
    private final List<EvalFactoryNode> childNodes = new ArrayList<EvalFactoryNode>();
    private short factoryNodeId;

    @Override
    public abstract EvalNode makeEvalNode(PatternAgentInstanceContext var1, EvalNode var2);

    public abstract void toPrecedenceFreeEPL(StringWriter var1);

    EvalNodeFactoryBase() {
    }

    @Override
    public void addChildNode(EvalFactoryNode childNode) {
        this.childNodes.add(childNode);
    }

    @Override
    public void addChildNodes(Collection<EvalFactoryNode> childNodesToAdd) {
        this.childNodes.addAll(childNodesToAdd);
    }

    @Override
    public List<EvalFactoryNode> getChildNodes() {
        return this.childNodes;
    }

    @Override
    public short getFactoryNodeId() {
        return this.factoryNodeId;
    }

    @Override
    public void setFactoryNodeId(short factoryNodeId) {
        this.factoryNodeId = factoryNodeId;
    }

    @Override
    public final void toEPL(StringWriter writer, PatternExpressionPrecedenceEnum parentPrecedence) {
        if (this.getPrecedence().getLevel() < parentPrecedence.getLevel()) {
            writer.write("(");
            this.toPrecedenceFreeEPL(writer);
            writer.write(")");
        } else {
            this.toPrecedenceFreeEPL(writer);
        }
    }
}

