/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import java.io.Serializable;
import java.util.Arrays;

public class EvalStateNodeNumber
implements Serializable {
    private static final long serialVersionUID = 4881487549563453035L;
    private int[] stateNumber;
    private int hashCode;

    public EvalStateNodeNumber() {
        this.stateNumber = new int[0];
        this.computeHashCode();
    }

    public EvalStateNodeNumber(int[] number) {
        this.stateNumber = number;
        this.computeHashCode();
    }

    public int getOrdinalNumber() {
        return this.stateNumber[this.stateNumber.length - 1];
    }

    public EvalStateNodeNumber newChildNum(int newStateNumber) {
        int[] num = new int[this.stateNumber.length + 1];
        System.arraycopy(this.stateNumber, 0, num, 0, this.stateNumber.length);
        num[this.stateNumber.length] = newStateNumber;
        return new EvalStateNodeNumber(num);
    }

    public EvalStateNodeNumber newSiblingState() {
        int size = this.stateNumber.length;
        int[] num = new int[size];
        System.arraycopy(this.stateNumber, 0, num, 0, size);
        num[size - 1] = this.stateNumber[size - 1] + 1;
        return new EvalStateNodeNumber(num);
    }

    public String toString() {
        return Arrays.toString(this.stateNumber);
    }

    public int[] getStateNumber() {
        return this.stateNumber;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof EvalStateNodeNumber)) {
            return false;
        }
        EvalStateNodeNumber other = (EvalStateNodeNumber)otherObj;
        int[] otherNum = other.getStateNumber();
        if (otherNum.length != this.stateNumber.length) {
            return false;
        }
        for (int i = 0; i < this.stateNumber.length; ++i) {
            if (otherNum[i] == this.stateNumber[i]) continue;
            return false;
        }
        return true;
    }

    private void computeHashCode() {
        this.hashCode = 7;
        for (int i = 0; i < this.stateNumber.length; ++i) {
            this.hashCode ^= this.stateNumber[i];
        }
    }
}

