/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.schedule;

import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ScheduleHandleCallbackProxy
implements InvocationHandler {
    private static Method target = JavaClassHelper.getMethodByName(ScheduleHandleCallback.class, "scheduledTrigger");
    private final String engineURI;
    private final String statementName;
    private final ScheduleHandleCallback scheduleHandleCallback;

    public static Object newInstance(String engineURI, String statementName, ScheduleHandleCallback scheduleHandleCallback) {
        return Proxy.newProxyInstance(scheduleHandleCallback.getClass().getClassLoader(), JavaClassHelper.getSuperInterfaces(scheduleHandleCallback.getClass()), (InvocationHandler)new ScheduleHandleCallbackProxy(engineURI, statementName, scheduleHandleCallback));
    }

    public ScheduleHandleCallbackProxy(String engineURI, String statementName, ScheduleHandleCallback scheduleHandleCallback) {
        this.engineURI = engineURI;
        this.statementName = statementName;
        this.scheduleHandleCallback = scheduleHandleCallback;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.getName().equals(target.getName()) && AuditPath.isInfoEnabled()) {
            StringWriter message = new StringWriter();
            message.write("trigger handle ");
            JavaClassHelper.writeInstance(message, this.scheduleHandleCallback, true);
            AuditPath.auditLog(this.engineURI, this.statementName, AuditEnum.SCHEDULE, message.toString());
        }
        return m.invoke((Object)this.scheduleHandleCallback, args);
    }
}

