/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.annotation.EventRepresentation;
import com.espertech.esper.client.soda.AnnotationPart;
import com.espertech.esper.client.soda.EPStatementObjectModel;
import com.espertech.esper.core.service.EPServiceProviderSPI;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Collections;
import java.util.Map;

public enum EventRepresentationEnum {
    OBJECTARRAY("@EventRepresentation(array=true)", Object[].class, " objectarray"),
    MAP("@EventRepresentation(array=false)", Map.class, " map"),
    DEFAULT(null, null, "");

    private final String annotationText;
    private final Class outputType;
    private final String outputTypeCreateSchemaName;

    private EventRepresentationEnum(String annotationText, Class outputType, String outputTypeCreateSchemaName) {
        if (annotationText == null) {
            this.annotationText = "";
            this.outputType = Configuration.EventRepresentation.getDefault() == Configuration.EventRepresentation.OBJECTARRAY ? Object[].class : Map.class;
        } else {
            this.annotationText = annotationText;
            this.outputType = outputType;
        }
        this.outputTypeCreateSchemaName = outputTypeCreateSchemaName;
    }

    public static EventRepresentationEnum getEngineDefault(EPServiceProvider engine) {
        EPServiceProviderSPI spi = (EPServiceProviderSPI)engine;
        if (spi.getConfigurationInformation().getEngineDefaults().getEventMeta().getDefaultEventRepresentation() == Configuration.EventRepresentation.OBJECTARRAY) {
            return OBJECTARRAY;
        }
        return MAP;
    }

    public String getAnnotationText() {
        return this.annotationText;
    }

    public Class getOutputClass() {
        return this.outputType;
    }

    public String getOutputTypeCreateSchemaName() {
        return this.outputTypeCreateSchemaName;
    }

    public boolean matchesClass(Class representationType) {
        return JavaClassHelper.isSubclassOrImplementsInterface(representationType, this.outputType);
    }

    public boolean isObjectArrayEvent() {
        return this.outputType == Object[].class;
    }

    public void addAnnotation(EPStatementObjectModel model) {
        if (this == DEFAULT) {
            return;
        }
        AnnotationPart part = new AnnotationPart(EventRepresentation.class.getSimpleName());
        part.addValue("array", this == OBJECTARRAY);
        model.setAnnotations(Collections.singletonList(part));
    }
}

