/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.visitor.ExprNodeSummaryVisitor;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewParameterException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ViewFactorySupport
implements ViewFactory {
    private static Log log = LogFactory.getLog(ViewFactorySupport.class);

    @Override
    public boolean canReuse(View view) {
        return false;
    }

    public static Object validateAndEvaluate(String viewName, StatementContext statementContext, ExprNode expression) throws ViewParameterException {
        return ViewFactorySupport.validateAndEvaluateExpr(viewName, statementContext, expression, new StreamTypeServiceImpl(statementContext.getEngineURI(), false), 0);
    }

    public static List<Object> validateAndEvaluate(String viewName, StatementContext statementContext, List<ExprNode> expressions) throws ViewParameterException {
        ArrayList<Object> results = new ArrayList<Object>();
        int expressionNumber = 0;
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(statementContext.getEngineURI(), false);
        for (ExprNode expr : expressions) {
            Object result = ViewFactorySupport.validateAndEvaluateExpr(viewName, statementContext, expr, streamTypeService, expressionNumber);
            results.add(result);
            ++expressionNumber;
        }
        return results;
    }

    public static ExprNode[] validate(String viewName, EventType eventType, StatementContext statementContext, List<ExprNode> expressions, boolean allowConstantResult) throws ViewParameterException {
        ArrayList<ExprNode> results = new ArrayList<ExprNode>();
        int expressionNumber = 0;
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(eventType, null, false, statementContext.getEngineURI());
        for (ExprNode expr : expressions) {
            ExprNode validated = ViewFactorySupport.validateExpr(viewName, statementContext, expr, streamTypeService, expressionNumber);
            results.add(validated);
            if (!allowConstantResult && validated.isConstantResult()) {
                String message = "Invalid view parameter expression " + expressionNumber + ViewFactorySupport.getViewDesc(viewName) + ", the expression returns a constant result value, are you sure?";
                log.error((Object)message);
                throw new ViewParameterException(message);
            }
            ++expressionNumber;
        }
        return results.toArray(new ExprNode[results.size()]);
    }

    public static void assertReturnsNonConstant(String viewName, ExprNode expression, int index) throws ViewParameterException {
        if (expression.isConstantResult()) {
            String message = "Invalid view parameter expression " + index + ViewFactorySupport.getViewDesc(viewName) + ", the expression returns a constant result value, are you sure?";
            log.error((Object)message);
            throw new ViewParameterException(message);
        }
    }

    public static Object evaluateAssertNoProperties(String viewName, ExprNode expression, int index, ExprEvaluatorContext exprEvaluatorContext) throws ViewParameterException {
        ExprNodeSummaryVisitor visitor = new ExprNodeSummaryVisitor();
        expression.accept(visitor);
        if (!visitor.isPlain()) {
            String message = "Invalid view parameter expression " + index + ViewFactorySupport.getViewDesc(viewName) + ", " + visitor.getMessage() + " are not allowed within the expression";
            throw new ViewParameterException(message);
        }
        return expression.getExprEvaluator().evaluate(null, false, exprEvaluatorContext);
    }

    public static Object validateAndEvaluateExpr(String viewName, StatementContext statementContext, ExprNode expression, StreamTypeService streamTypeService, int expressionNumber) throws ViewParameterException {
        ExprNode validated = ViewFactorySupport.validateExpr(viewName, statementContext, expression, streamTypeService, expressionNumber);
        try {
            return validated.getExprEvaluator().evaluate(null, true, new ExprEvaluatorContextStatement(statementContext, false));
        }
        catch (RuntimeException ex) {
            String message = "Failed to evaluate parameter expression " + expressionNumber + ViewFactorySupport.getViewDesc(viewName);
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            log.error((Object)message, (Throwable)ex);
            throw new ViewParameterException(message, ex);
        }
    }

    public static ExprNode validateExpr(String viewName, StatementContext statementContext, ExprNode expression, StreamTypeService streamTypeService, int expressionNumber) throws ViewParameterException {
        ExprNode validated;
        try {
            ExprEvaluatorContextStatement exprEvaluatorContext = new ExprEvaluatorContextStatement(statementContext, false);
            ExprValidationContext validationContext = new ExprValidationContext(streamTypeService, statementContext.getMethodResolutionService(), null, statementContext.getSchedulingService(), statementContext.getVariableService(), statementContext.getTableService(), exprEvaluatorContext, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor(), false, false, false, false, null, false);
            validated = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.VIEWPARAMETER, expression, validationContext);
        }
        catch (ExprValidationException ex) {
            String message = "Invalid parameter expression " + expressionNumber + ViewFactorySupport.getViewDesc(viewName);
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            log.error((Object)message, (Throwable)ex);
            throw new ViewParameterException(message, ex);
        }
        return validated;
    }

    private static String getViewDesc(String viewName) {
        return " for " + viewName + " view";
    }

    public static String getViewParamMessageNumericOrTimePeriod(String viewName) {
        return viewName + " view requires a single numeric or time period parameter";
    }
}

