/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.view.EventStream;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import java.util.Iterator;

public final class ZeroDepthStreamNoIterate
implements EventStream {
    private View[] children = ViewSupport.EMPTY_VIEW_ARRAY;
    private final EventType eventType;

    public ZeroDepthStreamNoIterate(EventType eventType) {
        this.eventType = eventType;
    }

    @Override
    public void insert(EventBean[] events) {
        for (View childView : this.children) {
            childView.update(events, null);
        }
    }

    @Override
    public final void insert(EventBean theEvent) {
        EventBean[] row = new EventBean[]{theEvent};
        for (View childView : this.children) {
            childView.update(row, null);
        }
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return CollectionUtil.NULL_EVENT_ITERATOR;
    }

    @Override
    public final View addView(View view) {
        this.children = ViewSupport.addView(this.children, view);
        view.setParent(this);
        return view;
    }

    @Override
    public final View[] getViews() {
        return this.children;
    }

    @Override
    public final boolean removeView(View view) {
        int index = ViewSupport.findViewIndex(this.children, view);
        if (index == -1) {
            return false;
        }
        this.children = ViewSupport.removeView(this.children, index);
        view.setParent(null);
        return true;
    }

    @Override
    public final boolean hasViews() {
        return this.children.length > 0;
    }

    @Override
    public void removeAllViews() {
        this.children = ViewSupport.EMPTY_VIEW_ARRAY;
    }
}

