/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.ext;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprOrderedExpr;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ext.IStreamSortRankRandomAccess;
import com.espertech.esper.view.ext.SortWindowView;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import java.util.List;

public class SortWindowViewFactory
implements DataWindowViewFactory,
DataWindowViewWithPrevious {
    private static final String NAME = "Sort";
    private List<ExprNode> viewParameters;
    protected ExprNode[] sortCriteriaExpressions;
    protected ExprEvaluator[] sortCriteriaEvaluators;
    protected boolean[] isDescendingValues;
    protected int sortWindowSize;
    private EventType eventType;
    private boolean useCollatorSort = false;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> viewParams) throws ViewParameterException {
        this.viewParameters = viewParams;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
        String message = "Sort window requires a numeric size parameter and a list of expressions providing sort keys";
        if (this.viewParameters.size() < 2) {
            throw new ViewParameterException(message);
        }
        ExprNode[] validated = ViewFactorySupport.validate("Sort window", parentEventType, statementContext, this.viewParameters, true);
        for (int i = 1; i < validated.length; ++i) {
            ViewFactorySupport.assertReturnsNonConstant("Sort window", validated[i], i);
        }
        ExprEvaluatorContextStatement exprEvaluatorContext = new ExprEvaluatorContextStatement(statementContext, false);
        Object sortSize = ViewFactorySupport.evaluateAssertNoProperties("Sort window", validated[0], 0, exprEvaluatorContext);
        if (sortSize == null || !(sortSize instanceof Number)) {
            throw new ViewParameterException(message);
        }
        this.sortWindowSize = ((Number)sortSize).intValue();
        this.sortCriteriaExpressions = new ExprNode[validated.length - 1];
        this.isDescendingValues = new boolean[this.sortCriteriaExpressions.length];
        for (int i = 1; i < validated.length; ++i) {
            if (validated[i] instanceof ExprOrderedExpr) {
                this.isDescendingValues[i - 1] = ((ExprOrderedExpr)validated[i]).isDescending();
                this.sortCriteriaExpressions[i - 1] = validated[i].getChildNodes()[0];
                continue;
            }
            this.sortCriteriaExpressions[i - 1] = validated[i];
        }
        this.sortCriteriaEvaluators = ExprNodeUtility.getEvaluators(this.sortCriteriaExpressions);
        if (statementContext.getConfigSnapshot() != null) {
            this.useCollatorSort = statementContext.getConfigSnapshot().getEngineDefaults().getLanguage().isSortUsingCollator();
        }
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        IStreamSortRankRandomAccess sortedRandomAccess = agentInstanceViewFactoryContext.getStatementContext().getViewServicePreviousFactory().getOptPreviousExprSortedRankedAccess(agentInstanceViewFactoryContext);
        return new SortWindowView(this, this.sortCriteriaExpressions, this.sortCriteriaEvaluators, this.isDescendingValues, this.sortWindowSize, sortedRandomAccess, this.useCollatorSort, agentInstanceViewFactoryContext);
    }

    @Override
    public Object makePreviousGetter() {
        return new RandomAccessByIndexGetter();
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof SortWindowView)) {
            return false;
        }
        SortWindowView other = (SortWindowView)view;
        if (other.getSortWindowSize() != this.sortWindowSize || !this.compare(other.getIsDescendingValues(), this.isDescendingValues) || !ExprNodeUtility.deepEquals(other.getSortCriteriaExpressions(), this.sortCriteriaExpressions)) {
            return false;
        }
        return other.isEmpty();
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    public ExprEvaluator[] getSortCriteriaEvaluators() {
        return this.sortCriteriaEvaluators;
    }

    public boolean[] getIsDescendingValues() {
        return this.isDescendingValues;
    }

    public int getSortWindowSize() {
        return this.sortWindowSize;
    }

    public boolean isUseCollatorSort() {
        return this.useCollatorSort;
    }

    private boolean compare(boolean[] one, boolean[] two) {
        if (one.length != two.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (one[i] == two[i]) continue;
            return false;
        }
        return true;
    }
}

