/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowBatchingViewFactory;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitableContainer;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewDataVisitorContained;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.internal.IntersectView;
import com.espertech.esper.view.internal.IntersectViewFactory;
import com.espertech.esper.view.internal.IntersectViewMarker;
import com.espertech.esper.view.internal.LastPostObserver;
import com.espertech.esper.view.internal.LastPostObserverView;
import com.espertech.esper.view.internal.ViewContainer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IntersectBatchView
extends ViewSupport
implements LastPostObserver,
CloneableView,
StoppableView,
DataWindowView,
IntersectViewMarker,
ViewDataVisitableContainer,
ViewContainer {
    private static final Log log = LogFactory.getLog(IntersectBatchView.class);
    protected final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    protected final IntersectViewFactory intersectViewFactory;
    protected final EventType eventType;
    protected final View[] views;
    private int batchViewIndex;
    private final EventBean[][] oldEventsPerView;
    private final EventBean[][] newEventsPerView;
    private final HashSet<EventBean> removedEvents = new LinkedHashSet<EventBean>();
    protected final boolean hasAsymetric;
    private boolean captureIRNonBatch;
    private boolean ignoreViewIRStream;

    public IntersectBatchView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, IntersectViewFactory factory, EventType eventType, List<View> viewList, List<ViewFactory> viewFactories, boolean hasAsymetric) {
        int i;
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.intersectViewFactory = factory;
        this.eventType = eventType;
        this.views = viewList.toArray(new View[viewList.size()]);
        this.oldEventsPerView = new EventBean[viewList.size()][];
        this.newEventsPerView = new EventBean[viewList.size()][];
        this.hasAsymetric = hasAsymetric;
        this.batchViewIndex = -1;
        for (i = 0; i < viewFactories.size(); ++i) {
            if (!(viewFactories.get(i) instanceof DataWindowBatchingViewFactory)) continue;
            this.batchViewIndex = i;
        }
        if (this.batchViewIndex == -1) {
            throw new IllegalStateException("Failed to find batch data window view");
        }
        for (i = 0; i < viewList.size(); ++i) {
            LastPostObserverView view = new LastPostObserverView(i);
            this.views[i].removeAllViews();
            this.views[i].addView(view);
            view.setObserver(this);
        }
    }

    @Override
    public View[] getViewContained() {
        return this.views;
    }

    @Override
    public View cloneView() {
        return this.intersectViewFactory.makeView(this.agentInstanceViewFactoryContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        int i;
        if (oldData != null && oldData.length != 0) {
            try {
                this.ignoreViewIRStream = true;
                for (i = 0; i < this.views.length; ++i) {
                    this.views[i].update(newData, oldData);
                }
            }
            finally {
                this.ignoreViewIRStream = false;
            }
        }
        if (newData != null) {
            try {
                this.captureIRNonBatch = true;
                for (i = 0; i < this.views.length; ++i) {
                    if (i == this.batchViewIndex) continue;
                    this.views[i].update(newData, oldData);
                }
            }
            finally {
                this.captureIRNonBatch = false;
            }
            this.removedEvents.clear();
            for (i = 0; i < this.views.length; ++i) {
                if (this.oldEventsPerView[i] == null) continue;
                for (int j = 0; j < this.views.length; ++j) {
                    if (i == j) continue;
                    this.views[j].update(null, this.oldEventsPerView[i]);
                    for (int k = 0; k < this.oldEventsPerView[i].length; ++k) {
                        this.removedEvents.add(this.oldEventsPerView[i][k]);
                    }
                }
                this.oldEventsPerView[i] = null;
            }
            EventBean[] newDataNonRemoved = this.hasAsymetric ? EventBeanUtility.getNewDataNonRemoved(newData, this.removedEvents, this.newEventsPerView) : EventBeanUtility.getNewDataNonRemoved(newData, this.removedEvents);
            if (newDataNonRemoved != null) {
                this.views[this.batchViewIndex].update(newDataNonRemoved, null);
            }
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.views[this.batchViewIndex].iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newData(int streamId, EventBean[] newEvents, EventBean[] oldEvents) {
        if (this.ignoreViewIRStream) {
            return;
        }
        if (this.captureIRNonBatch) {
            this.oldEventsPerView[streamId] = oldEvents;
            if (this.hasAsymetric) {
                this.newEventsPerView[streamId] = newEvents;
            }
            return;
        }
        if (streamId == this.batchViewIndex) {
            this.updateChildren(newEvents, oldEvents);
            if (newEvents != null) {
                try {
                    this.ignoreViewIRStream = true;
                    for (int i = 0; i < this.views.length; ++i) {
                        if (i == streamId) continue;
                        this.views[i].update(null, newEvents);
                    }
                }
                finally {
                    this.ignoreViewIRStream = false;
                }
            }
        } else if (oldEvents != null) {
            try {
                this.ignoreViewIRStream = true;
                for (int i = 0; i < this.views.length; ++i) {
                    if (i == streamId) continue;
                    this.views[i].update(null, oldEvents);
                }
            }
            finally {
                this.ignoreViewIRStream = false;
            }
        }
    }

    @Override
    public void stop() {
        for (View view : this.views) {
            if (!(view instanceof StoppableView)) continue;
            ((StoppableView)((Object)view)).stop();
        }
    }

    @Override
    public void visitViewContainer(ViewDataVisitorContained viewDataVisitor) {
        IntersectView.visitViewContained(viewDataVisitor, this.intersectViewFactory, this.views);
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.intersectViewFactory;
    }
}

