/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitableContainer;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewDataVisitorContained;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.internal.IntersectViewFactory;
import com.espertech.esper.view.internal.IntersectViewMarker;
import com.espertech.esper.view.internal.LastPostObserver;
import com.espertech.esper.view.internal.LastPostObserverView;
import com.espertech.esper.view.internal.ViewContainer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IntersectView
extends ViewSupport
implements LastPostObserver,
CloneableView,
StoppableView,
DataWindowView,
IntersectViewMarker,
ViewDataVisitableContainer,
ViewContainer {
    private static final Log log = LogFactory.getLog(IntersectView.class);
    protected final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    private final IntersectViewFactory intersectViewFactory;
    private final EventType eventType;
    protected final View[] views;
    private final EventBean[][] oldEventsPerView;
    private final Set<EventBean> removalEvents = new HashSet<EventBean>();
    private boolean isHasRemovestreamData;
    private boolean isRetainObserverEvents;
    private boolean isDiscardObserverEvents;

    public IntersectView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, IntersectViewFactory factory, EventType eventType, List<View> viewList) {
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.intersectViewFactory = factory;
        this.eventType = eventType;
        this.views = viewList.toArray(new View[viewList.size()]);
        this.oldEventsPerView = new EventBean[viewList.size()][];
        for (int i = 0; i < viewList.size(); ++i) {
            LastPostObserverView view = new LastPostObserverView(i);
            this.views[i].removeAllViews();
            this.views[i].addView(view);
            view.setObserver(this);
        }
    }

    @Override
    public View[] getViewContained() {
        return this.views;
    }

    @Override
    public View cloneView() {
        return this.intersectViewFactory.makeView(this.agentInstanceViewFactoryContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null) {
            this.isHasRemovestreamData = false;
            this.isRetainObserverEvents = true;
            try {
                for (View view : this.views) {
                    view.update(newData, oldData);
                }
            }
            finally {
                this.isRetainObserverEvents = false;
            }
            if (this.isHasRemovestreamData) {
                this.removalEvents.clear();
                for (int i = 0; i < this.oldEventsPerView.length; ++i) {
                    if (this.oldEventsPerView[i] == null) continue;
                    EventBean[] viewOldData = this.oldEventsPerView[i];
                    this.oldEventsPerView[i] = null;
                    for (EventBean oldEvent : viewOldData) {
                        this.removalEvents.add(oldEvent);
                    }
                    this.isDiscardObserverEvents = true;
                    try {
                        for (int j = 0; j < this.views.length; ++j) {
                            if (i == j) continue;
                            this.views[j].update(null, viewOldData);
                        }
                        continue;
                    }
                    finally {
                        this.isDiscardObserverEvents = false;
                    }
                }
                oldData = this.removalEvents.toArray(new EventBean[this.removalEvents.size()]);
            }
            this.updateChildren(newData, oldData);
        } else if (oldData != null) {
            this.isDiscardObserverEvents = true;
            try {
                for (View view : this.views) {
                    view.update(null, oldData);
                }
            }
            finally {
                this.isDiscardObserverEvents = false;
            }
            this.updateChildren(null, oldData);
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.views[0].iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newData(int streamId, EventBean[] newEvents, EventBean[] oldEvents) {
        if (oldEvents == null || this.isDiscardObserverEvents) {
            return;
        }
        if (this.isRetainObserverEvents) {
            this.oldEventsPerView[streamId] = oldEvents;
            this.isHasRemovestreamData = true;
            return;
        }
        this.isDiscardObserverEvents = true;
        try {
            for (int i = 0; i < this.views.length; ++i) {
                if (i == streamId) continue;
                this.views[i].update(null, oldEvents);
            }
        }
        finally {
            this.isDiscardObserverEvents = false;
        }
        this.updateChildren(null, oldEvents);
    }

    @Override
    public void stop() {
        for (View view : this.views) {
            if (!(view instanceof StoppableView)) continue;
            ((StoppableView)((Object)view)).stop();
        }
    }

    @Override
    public void visitViewContainer(ViewDataVisitorContained viewDataVisitor) {
        IntersectView.visitViewContained(viewDataVisitor, this.intersectViewFactory, this.views);
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        throw new UnsupportedOperationException();
    }

    public static void visitViewContained(ViewDataVisitorContained viewDataVisitor, ViewFactory viewFactory, View[] views) {
        viewDataVisitor.visitPrimary(viewFactory.getViewName(), views.length);
        for (int i = 0; i < views.length; ++i) {
            viewDataVisitor.visitContained(i, views[i]);
        }
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.intersectViewFactory;
    }
}

