/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.std.GroupByView;
import com.espertech.esper.view.std.GroupByViewFactoryMarker;
import com.espertech.esper.view.std.GroupByViewImpl;
import com.espertech.esper.view.std.GroupByViewReclaimAged;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupByViewFactory
implements ViewFactory,
GroupByViewFactoryMarker {
    private static Log log = LogFactory.getLog(GroupByViewFactory.class);
    protected List<ExprNode> viewParameters;
    protected ExprNode[] criteriaExpressions;
    private EventType eventType;
    protected boolean isReclaimAged;
    protected double reclaimMaxAge;
    protected double reclaimFrequency;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
        Hint reclaimGroupAged = HintEnum.RECLAIM_GROUP_AGED.getHint(viewFactoryContext.getStatementContext().getAnnotations());
        if (reclaimGroupAged != null) {
            this.isReclaimAged = true;
            String hintValueMaxAge = HintEnum.RECLAIM_GROUP_AGED.getHintAssignedValue(reclaimGroupAged);
            if (hintValueMaxAge == null) {
                throw new ViewParameterException("Required hint value for hint '" + (Object)((Object)HintEnum.RECLAIM_GROUP_AGED) + "' has not been provided");
            }
            try {
                this.reclaimMaxAge = Double.parseDouble(hintValueMaxAge);
            }
            catch (RuntimeException ex) {
                throw new ViewParameterException("Required hint value for hint '" + (Object)((Object)HintEnum.RECLAIM_GROUP_AGED) + "' value '" + hintValueMaxAge + "' could not be parsed as a double value");
            }
            String hintValueFrequency = HintEnum.RECLAIM_GROUP_FREQ.getHintAssignedValue(reclaimGroupAged);
            if (hintValueFrequency == null) {
                this.reclaimFrequency = this.reclaimMaxAge;
            } else {
                try {
                    this.reclaimFrequency = Double.parseDouble(hintValueFrequency);
                }
                catch (RuntimeException ex) {
                    throw new ViewParameterException("Required hint value for hint '" + (Object)((Object)HintEnum.RECLAIM_GROUP_FREQ) + "' value '" + hintValueFrequency + "' could not be parsed as a double value");
                }
            }
            if (this.reclaimMaxAge < 0.1) {
                log.warn((Object)"Reclaim max age parameter is less then 100 milliseconds, are your sure?");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using reclaim-aged strategy for group-window age " + this.reclaimMaxAge + " frequency " + this.reclaimFrequency));
            }
        }
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.criteriaExpressions = ViewFactorySupport.validate(this.getViewName(), parentEventType, statementContext, this.viewParameters, false);
        if (this.criteriaExpressions.length == 0) {
            String errorMessage = this.getViewName() + " view requires a one or more expressions provinding unique values as parameters";
            throw new ViewParameterException(errorMessage);
        }
        this.eventType = parentEventType;
    }

    @Override
    public ExprNode[] getCriteriaExpressions() {
        return this.criteriaExpressions;
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        if (this.isReclaimAged) {
            return new GroupByViewReclaimAged(agentInstanceViewFactoryContext, this.criteriaExpressions, ExprNodeUtility.getEvaluators(this.criteriaExpressions), this.reclaimMaxAge, this.reclaimFrequency);
        }
        return new GroupByViewImpl(agentInstanceViewFactoryContext, this.criteriaExpressions, ExprNodeUtility.getEvaluators(this.criteriaExpressions));
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof GroupByView)) {
            return false;
        }
        if (this.isReclaimAged) {
            return false;
        }
        GroupByView myView = (GroupByView)view;
        return ExprNodeUtility.deepEquals(myView.getCriteriaExpressions(), this.criteriaExpressions);
    }

    @Override
    public boolean isReclaimAged() {
        return this.isReclaimAged;
    }

    public double getReclaimMaxAge() {
        return this.reclaimMaxAge;
    }

    public double getReclaimFrequency() {
        return this.reclaimFrequency;
    }

    @Override
    public String getViewName() {
        return "Group-By";
    }
}

