/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.IterablesListIterator;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.std.AddPropertyValueView;
import com.espertech.esper.view.std.MergeViewMarker;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MergeView
extends ViewSupport
implements CloneableView,
MergeViewMarker {
    private final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private final Collection<View> parentViews;
    private final ExprNode[] groupFieldNames;
    private final EventType eventType;
    private final boolean removable;
    private static final Log log = LogFactory.getLog(MergeView.class);

    public MergeView(AgentInstanceViewFactoryChainContext agentInstanceContext, ExprNode[] groupCriteria, EventType resultEventType, boolean removable) {
        this.removable = removable;
        this.parentViews = !removable ? new ArrayDeque<View>() : new HashSet<View>();
        this.agentInstanceContext = agentInstanceContext;
        this.groupFieldNames = groupCriteria;
        this.eventType = resultEventType;
    }

    @Override
    public View cloneView() {
        return new MergeView(this.agentInstanceContext, this.groupFieldNames, this.eventType, this.removable);
    }

    @Override
    public final ExprNode[] getGroupFieldNames() {
        return this.groupFieldNames;
    }

    @Override
    public final void addParentView(AddPropertyValueView parentView) {
        this.parentViews.add(parentView);
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        this.updateChildren(newData, oldData);
    }

    @Override
    public final Iterator<EventBean> iterator() {
        ArrayDeque<View> iterables = new ArrayDeque<View>();
        for (View dataView : this.parentViews) {
            iterables.add(dataView);
        }
        return new IterablesListIterator(iterables.iterator());
    }

    public final String toString() {
        return this.getClass().getName() + " groupFieldName=" + Arrays.toString(this.groupFieldNames);
    }

    public void removeParentView(View view) {
        this.parentViews.remove(view);
    }
}

