/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stream;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.annotation.Audit;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.EventStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class EventStreamProxy
implements InvocationHandler {
    private final String engineURI;
    private final String statementName;
    private final String eventTypeAndFilter;
    private final EventStream eventStream;

    public static EventStream getAuditProxy(String engineURI, String statementName, Annotation[] annotations, FilterSpecCompiled filterSpec, EventStream designated) {
        Audit audit = AuditEnum.STREAM.getAudit(annotations);
        if (audit == null) {
            return designated;
        }
        StringWriter writer = new StringWriter();
        writer.write(filterSpec.getFilterForEventType().getName());
        if (filterSpec.getParameters() != null && filterSpec.getParameters().length > 0) {
            writer.write(40);
            String delimiter = "";
            for (FilterSpecParam[] paramLine : filterSpec.getParameters()) {
                writer.write(delimiter);
                EventStreamProxy.writeFilter(writer, paramLine);
                delimiter = " or ";
            }
            writer.write(41);
        }
        return (EventStream)EventStreamProxy.newInstance(engineURI, statementName, writer.toString(), designated);
    }

    private static void writeFilter(StringWriter writer, FilterSpecParam[] paramLine) {
        String delimiter = "";
        for (FilterSpecParam param : paramLine) {
            writer.write(delimiter);
            writer.write(param.getLookupable().getExpression());
            writer.write(param.getFilterOperator().getTextualOp());
            writer.write("...");
            delimiter = ",";
        }
    }

    public static Object newInstance(String engineURI, String statementName, String eventTypeAndFilter, EventStream eventStream) {
        return Proxy.newProxyInstance(eventStream.getClass().getClassLoader(), JavaClassHelper.getSuperInterfaces(eventStream.getClass()), (InvocationHandler)new EventStreamProxy(engineURI, statementName, eventTypeAndFilter, eventStream));
    }

    public EventStreamProxy(String engineURI, String statementName, String eventTypeAndFilter, EventStream eventStream) {
        this.engineURI = engineURI;
        this.statementName = statementName;
        this.eventTypeAndFilter = eventTypeAndFilter;
        this.eventStream = eventStream;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.getName().equals("insert") && AuditPath.isInfoEnabled()) {
            Object arg = args[0];
            String events = "(undefined)";
            if (arg instanceof EventBean[]) {
                events = EventBeanUtility.summarize((EventBean[])arg);
            } else if (arg instanceof EventBean) {
                events = EventBeanUtility.summarize((EventBean)arg);
            }
            AuditPath.auditLog(this.engineURI, this.statementName, AuditEnum.STREAM, this.eventTypeAndFilter + " inserted " + events);
        }
        return m.invoke((Object)this.eventStream, args);
    }
}

