/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.TimeWindow;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.EngineLevelExtensionServicesContext;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.schedule.ScheduleAdjustmentCallback;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.TimeWindowViewFactory;
import java.util.ArrayDeque;
import java.util.Iterator;

public class TimeWindowView
extends ViewSupport
implements CloneableView,
DataWindowView,
ScheduleAdjustmentCallback,
StoppableView,
StopCallback {
    private final TimeWindowViewFactory timeWindowViewFactory;
    private final ExprTimePeriodEvalDeltaConst timeDeltaComputation;
    protected final TimeWindow timeWindow;
    private final ViewUpdatedCollection viewUpdatedCollection;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private final ScheduleSlot scheduleSlot;
    private final EPStatementHandleCallback handle;

    public TimeWindowView(AgentInstanceViewFactoryChainContext agentInstanceContext, TimeWindowViewFactory timeWindowViewFactory, ExprTimePeriodEvalDeltaConst timeDeltaComputation, ViewUpdatedCollection viewUpdatedCollection) {
        this.agentInstanceContext = agentInstanceContext;
        this.timeWindowViewFactory = timeWindowViewFactory;
        this.timeDeltaComputation = timeDeltaComputation;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        this.timeWindow = new TimeWindow(agentInstanceContext.isRemoveStream());
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(EngineLevelExtensionServicesContext extensionServicesContext) {
                TimeWindowView.this.expire();
            }
        };
        this.handle = new EPStatementHandleCallback(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        if (agentInstanceContext.getStatementContext().getScheduleAdjustmentService() != null) {
            agentInstanceContext.getStatementContext().getScheduleAdjustmentService().addCallback(this);
        }
        agentInstanceContext.addTerminationCallback(this);
    }

    @Override
    public void adjust(long delta) {
        this.timeWindow.adjust(delta);
    }

    @Override
    public View cloneView() {
        return this.timeWindowViewFactory.makeView(this.agentInstanceContext);
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        int i;
        long timestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                this.timeWindow.remove(oldData[i]);
            }
        }
        if (newData != null && newData.length > 0) {
            if (this.timeWindow.isEmpty()) {
                long current = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
                this.scheduleCallback(this.timeDeltaComputation.deltaMillisecondsAdd(current));
            }
            for (i = 0; i < newData.length; ++i) {
                this.timeWindow.add(timestamp, newData[i]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(newData, null);
            }
        }
        if (this.hasViews()) {
            this.updateChildren(newData, oldData);
        }
    }

    protected final void expire() {
        long current = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        long expireBeforeTimestamp = current - this.timeDeltaComputation.deltaMillisecondsSubtract(current) + 1L;
        ArrayDeque<EventBean> expired = this.timeWindow.expireEvents(expireBeforeTimestamp);
        if (this.hasViews() && expired != null && !expired.isEmpty()) {
            EventBean[] oldEvents = expired.toArray(new EventBean[expired.size()]);
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(null, oldEvents);
            }
            this.updateChildren(null, oldEvents);
        }
        this.scheduleExpiryCallback();
    }

    protected void scheduleExpiryCallback() {
        if (this.timeWindow.isEmpty()) {
            return;
        }
        Long oldestTimestamp = this.timeWindow.getOldestTimestamp();
        long currentTimestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        long scheduleMillisec = this.timeDeltaComputation.deltaMillisecondsAdd(oldestTimestamp) + oldestTimestamp - currentTimestamp;
        this.scheduleCallback(scheduleMillisec);
    }

    public ExprTimePeriodEvalDeltaConst getTimeDeltaComputation() {
        return this.timeDeltaComputation;
    }

    private void scheduleCallback(long msecAfterCurrentTime) {
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(msecAfterCurrentTime, this.handle, this.scheduleSlot);
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.timeWindow.iterator();
    }

    public final String toString() {
        return this.getClass().getName();
    }

    public boolean isEmpty() {
        return this.timeWindow.isEmpty();
    }

    public void stopView() {
        this.stopSchedule();
        this.agentInstanceContext.removeTerminationCallback(this);
    }

    @Override
    public void stop() {
        this.stopSchedule();
    }

    public void stopSchedule() {
        if (this.handle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
        if (this.agentInstanceContext.getStatementContext().getScheduleAdjustmentService() != null) {
            this.agentInstanceContext.getStatementContext().getScheduleAdjustmentService().removeCallback(this);
        }
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        this.timeWindow.visitView(viewDataVisitor, this.timeWindowViewFactory);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.timeWindowViewFactory;
    }
}

