/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client;

import com.facebook.airlift.http.client.HeaderName;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.Response;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import javax.annotation.Nullable;

@Beta
public class UnexpectedResponseException
extends RuntimeException {
    private final Request request;
    private final int statusCode;
    private final String statusMessage;
    private final ListMultimap<HeaderName, String> headers;

    public UnexpectedResponseException(Request request, Response response) {
        this(String.format("%d: %s", response.getStatusCode(), response.getStatusMessage()), request, response.getStatusCode(), response.getStatusMessage(), (ListMultimap<HeaderName, String>)ImmutableListMultimap.copyOf(response.getHeaders()));
    }

    public UnexpectedResponseException(String message, Request request, Response response) {
        this(message, request, response.getStatusCode(), response.getStatusMessage(), (ListMultimap<HeaderName, String>)ImmutableListMultimap.copyOf(response.getHeaders()));
    }

    public UnexpectedResponseException(String message, Request request, int statusCode, String statusMessage, ListMultimap<HeaderName, String> headers) {
        super(message);
        this.request = request;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.headers = ImmutableListMultimap.copyOf(headers);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Nullable
    public String getHeader(String name) {
        List values = this.getHeaders().get((Object)HeaderName.of(name));
        return values.isEmpty() ? null : (String)values.get(0);
    }

    public List<String> getHeaders(String name) {
        return this.headers.get((Object)HeaderName.of(name));
    }

    public ListMultimap<HeaderName, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("request", (Object)this.request).add("statusCode", this.statusCode).add("statusMessage", (Object)this.statusMessage).add("headers", this.headers).toString();
    }
}

