/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client.thrift;

import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.thrift.ThriftBodyGenerator;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ThriftRequestUtils {
    public static final String APPLICATION_THRIFT_BINARY = "application/x-thrift+binary";
    public static final String APPLICATION_THRIFT_COMPACT = "application/x-thrift+compact";
    public static final String APPLICATION_THRIFT_FB_COMPACT = "application/x-thrift+fb_compact";
    public static final List<String> validThriftMimeTypes = ImmutableList.of((Object)"application/x-thrift+binary", (Object)"application/x-thrift+compact", (Object)"application/x-thrift+fb_compact");

    private ThriftRequestUtils() {
    }

    public static Request.Builder prepareThriftPost(Protocol protocol) {
        String type = ThriftRequestUtils.getType(protocol);
        return Request.Builder.preparePost().setHeader("Accept", type).setHeader("Content-Type", type);
    }

    public static <T> Request.Builder prepareThriftPost(Protocol protocol, T instance, ThriftCodec<T> thriftCodec) {
        return ThriftRequestUtils.prepareThriftPost(protocol).setBodyGenerator(ThriftRequestUtils.createThriftBodyGenerator(instance, thriftCodec, protocol));
    }

    public static Request.Builder prepareThriftGet(Protocol protocol) {
        String type = ThriftRequestUtils.getType(protocol);
        return Request.Builder.prepareGet().setHeader("Accept", type);
    }

    public static Request.Builder prepareThriftDelete(Protocol protocol) {
        String type = ThriftRequestUtils.getType(protocol);
        return Request.Builder.prepareDelete().setHeader("Accept", type);
    }

    private static <T> ThriftBodyGenerator<T> createThriftBodyGenerator(T instance, ThriftCodec<T> thriftCodec, Protocol protocol) {
        return new ThriftBodyGenerator<T>(instance, thriftCodec, protocol);
    }

    private static String getType(Protocol protocol) {
        switch (protocol) {
            case BINARY: {
                return APPLICATION_THRIFT_BINARY;
            }
            case COMPACT: {
                return APPLICATION_THRIFT_COMPACT;
            }
            case FB_COMPACT: {
                return APPLICATION_THRIFT_FB_COMPACT;
            }
        }
        throw new IllegalArgumentException("Invalid thrift protocol");
    }
}

