/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.io;

import com.facebook.presto.hive.$internal.jodd.io.FileChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class FileMonitor {
    protected final Map<File, Long> files;
    protected final Set<FileChangeListener> listeners;
    protected final long pollingInterval;
    protected Timer timer;
    protected final Object lock = new Object();

    public FileMonitor(long pollingInterval) {
        this.pollingInterval = pollingInterval;
        this.files = new HashMap<File, Long>();
        this.listeners = new HashSet<FileChangeListener>();
        this.start();
    }

    public void start() {
        if (this.timer == null) {
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new FileMonitorNotifier(), 0L, this.pollingInterval);
        }
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorFile(File file) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.files.containsKey(file)) {
                long modifiedTime = file.exists() ? file.lastModified() : -1L;
                this.files.put(file, new Long(modifiedTime));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFile(File file) {
        Object object = this.lock;
        synchronized (object) {
            this.files.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(FileChangeListener fileChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            for (FileChangeListener listener : this.listeners) {
                if (listener != fileChangeListener) continue;
                return;
            }
            this.listeners.add(fileChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FileChangeListener fileChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<FileChangeListener> i = this.listeners.iterator();
            while (i.hasNext()) {
                FileChangeListener listener = i.next();
                if (listener != fileChangeListener) continue;
                i.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.clear();
        }
    }

    protected class FileMonitorNotifier
    extends TimerTask {
        protected FileMonitorNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = FileMonitor.this.lock;
            synchronized (object) {
                for (Map.Entry<File, Long> entry : FileMonitor.this.files.entrySet()) {
                    File file = entry.getKey();
                    long lastModifiedTime = entry.getValue();
                    long newModifiedTime = file.exists() ? file.lastModified() : -1L;
                    if (newModifiedTime == lastModifiedTime) continue;
                    entry.setValue(new Long(newModifiedTime));
                    for (FileChangeListener listener : FileMonitor.this.listeners) {
                        listener.onFileChange(file);
                    }
                }
            }
        }
    }
}

