/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.typeconverter.impl;

import com.facebook.presto.hive.$internal.jodd.typeconverter.TypeConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.TypeConverterManagerBean;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterArrayConverter
implements TypeConverter<char[]> {
    protected final TypeConverterManagerBean typeConverterManagerBean;

    public CharacterArrayConverter(TypeConverterManagerBean typeConverterManagerBean) {
        this.typeConverterManagerBean = typeConverterManagerBean;
    }

    @Override
    public char[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (!valueClass.isArray()) {
            return this.convertValueToArray(value);
        }
        return this.convertArrayToArray(value);
    }

    protected char convertType(Object value) {
        return this.typeConverterManagerBean.convertType(value, Character.TYPE).charValue();
    }

    protected char[] convertToSingleElementArray(Object value) {
        return new char[]{this.convertType(value)};
    }

    protected char[] convertValueToArray(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            char[] target = new char[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object element = list.get(i);
                target[i] = this.convertType(element);
            }
            return target;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            char[] target = new char[collection.size()];
            int i = 0;
            for (Object element : collection) {
                target[i] = this.convertType(element);
                ++i;
            }
            return target;
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            int count = 0;
            for (Object element : iterable) {
                ++count;
            }
            char[] target = new char[count];
            int i = 0;
            for (Object element : iterable) {
                target[i] = this.convertType(element);
                ++i;
            }
            return target;
        }
        if (value instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)value;
            char[] result = new char[charSequence.length()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = charSequence.charAt(i);
            }
            return result;
        }
        return this.convertToSingleElementArray(value);
    }

    protected char[] convertArrayToArray(Object value) {
        char[] result;
        Class<?> valueComponentType = value.getClass().getComponentType();
        if (valueComponentType == Character.TYPE) {
            return (char[])value;
        }
        if (valueComponentType.isPrimitive()) {
            result = this.convertPrimitiveArrayToArray(value, valueComponentType);
        } else {
            Object[] array = (Object[])value;
            result = new char[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.convertType(array[i]);
            }
        }
        return result;
    }

    protected char[] convertPrimitiveArrayToArray(Object value, Class primitiveComponentType) {
        char[] result;
        block9: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    result = null;
                                    if (primitiveComponentType == char[].class) {
                                        return (char[])value;
                                    }
                                    if (primitiveComponentType != Integer.TYPE) break block8;
                                    int[] array = (int[])value;
                                    result = new char[array.length];
                                    for (int i = 0; i < array.length; ++i) {
                                        result[i] = (char)array[i];
                                    }
                                    break block9;
                                }
                                if (primitiveComponentType != Long.TYPE) break block10;
                                long[] array = (long[])value;
                                result = new char[array.length];
                                for (int i = 0; i < array.length; ++i) {
                                    result[i] = (char)array[i];
                                }
                                break block9;
                            }
                            if (primitiveComponentType != Float.TYPE) break block11;
                            float[] array = (float[])value;
                            result = new char[array.length];
                            for (int i = 0; i < array.length; ++i) {
                                result[i] = (char)array[i];
                            }
                            break block9;
                        }
                        if (primitiveComponentType != Double.TYPE) break block12;
                        double[] array = (double[])value;
                        result = new char[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            result[i] = (char)array[i];
                        }
                        break block9;
                    }
                    if (primitiveComponentType != Short.TYPE) break block13;
                    short[] array = (short[])value;
                    result = new char[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        result[i] = (char)array[i];
                    }
                    break block9;
                }
                if (primitiveComponentType != Byte.TYPE) break block14;
                byte[] array = (byte[])value;
                result = new char[array.length];
                for (int i = 0; i < array.length; ++i) {
                    result[i] = (char)array[i];
                }
                break block9;
            }
            if (primitiveComponentType != Boolean.TYPE) break block9;
            boolean[] array = (boolean[])value;
            result = new char[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = (char)(array[i] ? 1 : 0);
            }
        }
        return result;
    }
}

