/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.typeconverter.impl;

import com.facebook.presto.hive.$internal.jodd.datetime.JDateTime;
import com.facebook.presto.hive.$internal.jodd.typeconverter.TypeConversionException;
import com.facebook.presto.hive.$internal.jodd.typeconverter.TypeConverter;
import com.facebook.presto.hive.$internal.jodd.util.StringUtil;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDateConverter
implements TypeConverter<java.sql.Date> {
    @Override
    public java.sql.Date convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Date) {
            return (java.sql.Date)value;
        }
        if (value instanceof Calendar) {
            return new java.sql.Date(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Date) {
            return new java.sql.Date(((Date)value).getTime());
        }
        if (value instanceof JDateTime) {
            return ((JDateTime)value).convertToSqlDate();
        }
        if (value instanceof Number) {
            return new java.sql.Date(((Number)value).longValue());
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits(stringValue)) {
            try {
                return java.sql.Date.valueOf(stringValue);
            }
            catch (IllegalArgumentException iaex) {
                throw new TypeConversionException(value, (Throwable)iaex);
            }
        }
        try {
            long milliseconds = Long.parseLong(stringValue);
            return new java.sql.Date(milliseconds);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

