/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain.tez;

import com.facebook.presto.hive.;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.json.JSONException;
import com.facebook.presto.hive.$internal.org.json.JSONObject;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.common.jsonexplain.JsonParser;
import org.apache.hadoop.hive.common.jsonexplain.tez.Connection;
import org.apache.hadoop.hive.common.jsonexplain.tez.Op;
import org.apache.hadoop.hive.common.jsonexplain.tez.Stage;
import org.apache.hadoop.hive.common.jsonexplain.tez.Vertex;

public class TezJsonParser
implements JsonParser {
    JSONObject inputObject;
    Map<String, Stage> stages;
    PrintStream outputStream;
    protected final Log LOG = LogFactory.getLog(this.getClass().getName());
    public static Set<Object> printSet = new HashSet<Object>();
    public static Map<Op, List<Connection>> inlineMap = new HashMap<Op, List<Connection>>();

    public void extractStagesAndPlans() throws JSONException, .JsonParseException, .JsonMappingException, Exception, IOException {
        JSONObject stagePlans;
        this.stages = new HashMap<String, Stage>();
        JSONObject dependency = this.inputObject.getJSONObject("STAGE DEPENDENCIES");
        if (dependency.length() > 0) {
            for (String stageName : JSONObject.getNames(dependency)) {
                this.stages.put(stageName, new Stage(stageName));
            }
            for (String stageName : JSONObject.getNames(dependency)) {
                JSONObject dependentStageNames = dependency.getJSONObject(stageName);
                this.stages.get(stageName).addDependency(dependentStageNames, this.stages);
            }
        }
        if ((stagePlans = this.inputObject.getJSONObject("STAGE PLANS")).length() > 0) {
            for (String stageName : JSONObject.getNames(stagePlans)) {
                JSONObject stagePlan = stagePlans.getJSONObject(stageName);
                this.stages.get(stageName).extractVertex(stagePlan);
            }
        }
    }

    public static String prefixString(List<Boolean> indentFlag) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < indentFlag.size(); ++index) {
            if (indentFlag.get(index).booleanValue()) {
                sb.append("|  ");
                continue;
            }
            sb.append("   ");
        }
        return sb.toString();
    }

    public static String prefixString(List<Boolean> indentFlag, String tail) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < indentFlag.size(); ++index) {
            if (indentFlag.get(index).booleanValue()) {
                sb.append("|  ");
                continue;
            }
            sb.append("   ");
        }
        int len = sb.length();
        return sb.replace(len - tail.length(), len, tail).toString();
    }

    @Override
    public void print(JSONObject inputObject, PrintStream outputStream) throws Exception {
        this.LOG.info("JsonParser is parsing\n" + inputObject.toString());
        this.inputObject = inputObject;
        this.outputStream = outputStream;
        this.extractStagesAndPlans();
        if (inputObject.has("cboInfo")) {
            outputStream.println(inputObject.getString("cboInfo"));
            outputStream.println();
        }
        for (Stage candidate : this.stages.values()) {
            if (candidate.tezStageDependency == null || candidate.tezStageDependency.size() <= 0) continue;
            outputStream.println("Vertex dependency in root stage");
            for (Map.Entry<Vertex, List<Connection>> entry : candidate.tezStageDependency.entrySet()) {
                StringBuffer sb = new StringBuffer();
                sb.append(entry.getKey().name);
                sb.append(" <- ");
                boolean printcomma = false;
                for (Connection connection : entry.getValue()) {
                    if (printcomma) {
                        sb.append(", ");
                    } else {
                        printcomma = true;
                    }
                    sb.append(connection.from.name + " (" + connection.type + ")");
                }
                outputStream.println(sb.toString());
            }
            outputStream.println();
        }
        ArrayList<Boolean> indentFlag = new ArrayList<Boolean>();
        for (Stage candidate : this.stages.values()) {
            if (!candidate.childStages.isEmpty()) continue;
            candidate.print(outputStream, indentFlag);
        }
    }

    public static void addInline(Op op, Connection connection) {
        List<Connection> list = inlineMap.get(op);
        if (list == null) {
            list = new ArrayList<Connection>();
            list.add(connection);
            inlineMap.put(op, list);
        } else {
            list.add(connection);
        }
    }

    public static boolean isInline(Vertex v) {
        for (List<Connection> list : inlineMap.values()) {
            for (Connection connection : list) {
                if (!connection.from.equals(v)) continue;
                return true;
            }
        }
        return false;
    }
}

