/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.debug;

import com.facebook.presto.hive.$internal.org.apache.commons.lang.StringUtils;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;

public class Utils {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile HotSpotDiagnosticMXBean hotspotMBean;

    public static void dumpHeapToTmp(String ... args) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (StringUtils.isBlank(tmpDir)) {
            tmpDir = "/tmp/";
        }
        String fileName = tmpDir + File.pathSeparatorChar + "dump";
        for (String arg : args) {
            fileName = fileName + "_" + arg;
        }
        fileName = fileName + "_" + System.nanoTime() + ".hprof";
        Utils.dumpHeap(fileName, true);
    }

    public static void dumpHeap(String fileName, boolean live) {
        if (hotspotMBean == null) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exp) {
                throw new RuntimeException(exp);
            }
        }
        try {
            hotspotMBean.dumpHeap(fileName, live);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    public static String toStringBinary(byte[] b, int off, int len) {
        StringBuilder result = new StringBuilder();
        try {
            String first = new String(b, off, len, "ISO-8859-1");
            for (int i = 0; i < first.length(); ++i) {
                int ch = first.charAt(i) & 0xFF;
                if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || " `~!@#$%^&*()-_=+[]{}\\|;:'\",.<>/?".indexOf(ch) >= 0) {
                    result.append(first.charAt(i));
                    continue;
                }
                result.append(String.format("\\x%02X", ch));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ISO-8859-1 not supported?", e);
        }
        return result.toString();
    }
}

