/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;

public class Heartbeater {
    private long lastHeartbeat = 0L;
    private long heartbeatInterval = 0L;
    private boolean dontHeartbeat = false;
    private HiveTxnManager txnMgr;
    private Configuration conf;
    private static final Log LOG = LogFactory.getLog(Heartbeater.class.getName());

    public Heartbeater(HiveTxnManager txnMgr, Configuration conf) {
        this.txnMgr = txnMgr;
        this.conf = conf;
    }

    public void heartbeat() throws IOException {
        long now;
        if (this.dontHeartbeat) {
            return;
        }
        if (this.txnMgr == null) {
            LOG.debug("txnMgr null, not heartbeating");
            this.dontHeartbeat = true;
            return;
        }
        if (this.heartbeatInterval == 0L) {
            this.heartbeatInterval = HiveConf.getTimeVar(this.conf, HiveConf.ConfVars.HIVE_TXN_TIMEOUT, TimeUnit.MILLISECONDS) / 2L;
            if (this.heartbeatInterval == 0L) {
                LOG.warn(HiveConf.ConfVars.HIVE_TXN_MANAGER.toString() + " not set, heartbeats won't be sent");
                this.dontHeartbeat = true;
                LOG.debug("heartbeat interval 0, not heartbeating");
                return;
            }
        }
        if ((now = System.currentTimeMillis()) - this.lastHeartbeat > this.heartbeatInterval) {
            try {
                LOG.debug("heartbeating");
                this.txnMgr.heartbeat();
            }
            catch (LockException e) {
                LOG.warn("Failed trying to heartbeat " + e.getMessage());
                throw new IOException(e);
            }
            this.lastHeartbeat = now;
        }
    }
}

