/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.MapOperator;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.tez.RecordSource;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class MapRecordSource
implements RecordSource {
    public static final Log LOG = LogFactory.getLog(MapRecordSource.class);
    private ExecMapperContext execContext = null;
    private MapOperator mapOp = null;
    private KeyValueReader reader = null;
    private final boolean grouped = false;

    void init(JobConf jconf, MapOperator mapOp, KeyValueReader reader) throws IOException {
        this.execContext = mapOp.getExecContext();
        this.mapOp = mapOp;
        this.reader = reader;
    }

    @Override
    public final boolean isGrouped() {
        return false;
    }

    @Override
    public boolean pushRecord() throws HiveException {
        block4: {
            this.execContext.resetRow();
            try {
                Object value;
                if (!this.reader.next()) break block4;
                try {
                    value = this.reader.getCurrentValue();
                }
                catch (IOException e) {
                    throw new HiveException(e);
                }
                return this.processRow(value);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        }
        return false;
    }

    private boolean processRow(Object value) {
        try {
            if (this.mapOp.getDone()) {
                return false;
            }
            this.mapOp.process((Writable)value);
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            LOG.fatal(StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
        return true;
    }
}

