/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTableResult;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public abstract class VectorMapJoinInnerGenerateResultOperator
extends VectorMapJoinGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(VectorMapJoinInnerGenerateResultOperator.class.getName());
    protected transient VectorMapJoinHashMapResult[] hashMapResults;
    protected transient int[] allMatchs;
    protected transient int[] equalKeySeriesHashMapResultIndices;
    protected transient int[] equalKeySeriesAllMatchIndices;
    protected transient boolean[] equalKeySeriesIsSingleValue;
    protected transient int[] equalKeySeriesDuplicateCounts;
    protected transient int[] spills;
    protected transient int[] spillHashMapResultIndices;

    public VectorMapJoinInnerGenerateResultOperator() {
    }

    public VectorMapJoinInnerGenerateResultOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(vContext, conf);
    }

    @Override
    protected void commonSetup(VectorizedRowBatch batch) throws HiveException {
        super.commonSetup(batch);
        VectorMapJoinHashMap baseHashMap = (VectorMapJoinHashMap)this.vectorMapJoinHashTable;
        this.hashMapResults = new VectorMapJoinHashMapResult[1024];
        for (int i = 0; i < this.hashMapResults.length; ++i) {
            this.hashMapResults[i] = baseHashMap.createHashMapResult();
        }
        this.allMatchs = new int[1024];
        this.equalKeySeriesHashMapResultIndices = new int[1024];
        this.equalKeySeriesAllMatchIndices = new int[1024];
        this.equalKeySeriesIsSingleValue = new boolean[1024];
        this.equalKeySeriesDuplicateCounts = new int[1024];
        this.spills = new int[1024];
        this.spillHashMapResultIndices = new int[1024];
    }

    protected void innerPerBatchSetup(VectorizedRowBatch batch) {
        for (int column : this.smallTableOutputVectorColumns) {
            ColumnVector smallTableColumn = batch.cols[column];
            smallTableColumn.reset();
        }
    }

    protected int finishInner(VectorizedRowBatch batch, int[] allMatchs, int allMatchCount, int[] equalKeySeriesHashMapResultIndices, int[] equalKeySeriesAllMatchIndices, boolean[] equalKeySeriesIsSingleValue, int[] equalKeySeriesDuplicateCounts, int equalKeySeriesCount, int[] spills, int[] spillHashMapResultIndices, int spillCount, VectorMapJoinHashMapResult[] hashMapResults, int hashMapResultCount) throws HiveException, IOException {
        int numSel = 0;
        if (allMatchCount > 0 && this.bigTableValueExpressions != null) {
            this.performValueExpressions(batch, allMatchs, allMatchCount);
        }
        for (int i = 0; i < equalKeySeriesCount; ++i) {
            int hashMapResultIndex = equalKeySeriesHashMapResultIndices[i];
            VectorMapJoinHashMapResult hashMapResult = hashMapResults[hashMapResultIndex];
            int allMatchesIndex = equalKeySeriesAllMatchIndices[i];
            boolean isSingleValue = equalKeySeriesIsSingleValue[i];
            int duplicateCount = equalKeySeriesDuplicateCounts[i];
            if (isSingleValue) {
                numSel = this.generateHashMapResultSingleValue(batch, hashMapResult, allMatchs, allMatchesIndex, duplicateCount, numSel);
                continue;
            }
            this.generateHashMapResultMultiValue(batch, hashMapResult, allMatchs, allMatchesIndex, duplicateCount);
        }
        if (spillCount > 0) {
            this.spillHashMapBatch(batch, hashMapResults, spills, spillHashMapResultIndices, spillCount);
        }
        return numSel;
    }

    protected int finishInnerRepeated(VectorizedRowBatch batch, JoinUtil.JoinResult joinResult, VectorMapJoinHashTableResult hashMapResult) throws HiveException, IOException {
        int numSel = 0;
        switch (joinResult) {
            case MATCH: {
                if (this.bigTableValueExpressions != null) {
                    for (VectorExpression ve : this.bigTableValueExpressions) {
                        ve.evaluate(batch);
                    }
                }
                numSel = this.generateHashMapResultRepeatedAll(batch, this.hashMapResults[0]);
                break;
            }
            case SPILL: {
                this.spillBatchRepeated(batch, this.hashMapResults[0]);
                break;
            }
        }
        return numSel;
    }
}

